/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MapUtil {
    private static final int MAXIMUM_CAPACITY = 0x40000000;

    public static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public static HashMap createHashMap(int cap) {
        int capacity = MapUtil.tableSizeFor(cap) << 1;
        return new HashMap(capacity);
    }

    public static LinkedHashMap createLinkedHashMap(int cap) {
        int capacity = MapUtil.tableSizeFor(cap) << 1;
        return new LinkedHashMap(capacity);
    }

    public static ConcurrentHashMap createConcurrentHashMap(int cap) {
        int capacity = MapUtil.tableSizeFor(cap) << 1;
        return new ConcurrentHashMap(capacity);
    }

    public static HashSet createHashSet(int cap) {
        int capacity = MapUtil.tableSizeFor(cap) << 1;
        return new HashSet(capacity);
    }

    public static Set createConcurrentHashSet(int cap) {
        int capacity = MapUtil.tableSizeFor(cap) << 1;
        return ConcurrentHashMap.newKeySet(capacity);
    }
}

