/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import io.nuls.contract.model.dto.BlockHeaderDto;
import io.nuls.contract.util.VMContext;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.Heap;
import io.nuls.contract.vm.MethodArea;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.OpCode;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.VMStack;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.exception.ErrorException;
import io.nuls.contract.vm.instructions.comparisons.Dcmp;
import io.nuls.contract.vm.instructions.comparisons.Fcmp;
import io.nuls.contract.vm.instructions.comparisons.IfAcmp;
import io.nuls.contract.vm.instructions.comparisons.IfCmp;
import io.nuls.contract.vm.instructions.comparisons.IfIcmp;
import io.nuls.contract.vm.instructions.comparisons.Lcmp;
import io.nuls.contract.vm.instructions.constants.Ldc;
import io.nuls.contract.vm.instructions.control.Goto;
import io.nuls.contract.vm.instructions.control.Jsr;
import io.nuls.contract.vm.instructions.control.Lookupswitch;
import io.nuls.contract.vm.instructions.control.Ret;
import io.nuls.contract.vm.instructions.control.Return;
import io.nuls.contract.vm.instructions.control.Tableswitch;
import io.nuls.contract.vm.instructions.conversions.D2x;
import io.nuls.contract.vm.instructions.conversions.F2x;
import io.nuls.contract.vm.instructions.conversions.I2x;
import io.nuls.contract.vm.instructions.conversions.L2x;
import io.nuls.contract.vm.instructions.extended.Ifnonnull;
import io.nuls.contract.vm.instructions.extended.Ifnull;
import io.nuls.contract.vm.instructions.extended.Multianewarray;
import io.nuls.contract.vm.instructions.loads.Aload;
import io.nuls.contract.vm.instructions.loads.Dload;
import io.nuls.contract.vm.instructions.loads.Fload;
import io.nuls.contract.vm.instructions.loads.Iload;
import io.nuls.contract.vm.instructions.loads.Lload;
import io.nuls.contract.vm.instructions.loads.Xaload;
import io.nuls.contract.vm.instructions.math.Add;
import io.nuls.contract.vm.instructions.math.And;
import io.nuls.contract.vm.instructions.math.Div;
import io.nuls.contract.vm.instructions.math.Iinc;
import io.nuls.contract.vm.instructions.math.Mul;
import io.nuls.contract.vm.instructions.math.Neg;
import io.nuls.contract.vm.instructions.math.Or;
import io.nuls.contract.vm.instructions.math.Rem;
import io.nuls.contract.vm.instructions.math.Shl;
import io.nuls.contract.vm.instructions.math.Shr;
import io.nuls.contract.vm.instructions.math.Sub;
import io.nuls.contract.vm.instructions.math.Ushr;
import io.nuls.contract.vm.instructions.math.Xor;
import io.nuls.contract.vm.instructions.references.Anewarray;
import io.nuls.contract.vm.instructions.references.Arraylength;
import io.nuls.contract.vm.instructions.references.Athrow;
import io.nuls.contract.vm.instructions.references.Checkcast;
import io.nuls.contract.vm.instructions.references.Getfield;
import io.nuls.contract.vm.instructions.references.Getstatic;
import io.nuls.contract.vm.instructions.references.Instanceof;
import io.nuls.contract.vm.instructions.references.Invokedynamic;
import io.nuls.contract.vm.instructions.references.Invokeinterface;
import io.nuls.contract.vm.instructions.references.Invokespecial;
import io.nuls.contract.vm.instructions.references.Invokestatic;
import io.nuls.contract.vm.instructions.references.Invokevirtual;
import io.nuls.contract.vm.instructions.references.Monitorenter;
import io.nuls.contract.vm.instructions.references.Monitorexit;
import io.nuls.contract.vm.instructions.references.New;
import io.nuls.contract.vm.instructions.references.Newarray;
import io.nuls.contract.vm.instructions.references.Putfield;
import io.nuls.contract.vm.instructions.references.Putstatic;
import io.nuls.contract.vm.instructions.stack.Dup;
import io.nuls.contract.vm.instructions.stack.Pop;
import io.nuls.contract.vm.instructions.stack.Swap;
import io.nuls.contract.vm.instructions.stores.Astore;
import io.nuls.contract.vm.instructions.stores.Dstore;
import io.nuls.contract.vm.instructions.stores.Fstore;
import io.nuls.contract.vm.instructions.stores.Istore;
import io.nuls.contract.vm.instructions.stores.Lstore;
import io.nuls.contract.vm.instructions.stores.Xastore;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeAddress;
import io.nuls.contract.vm.program.ProgramInternalCall;
import io.nuls.contract.vm.program.ProgramInternalCreate;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramMethodArg;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.program.ProgramTransfer;
import io.nuls.contract.vm.program.impl.ProgramContext;
import io.nuls.contract.vm.program.impl.ProgramExecutorImpl;
import io.nuls.contract.vm.program.impl.ProgramInvoke;
import io.nuls.core.crypto.HexUtil;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ethereum.core.Repository;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VM {
    private Logger log = LoggerFactory.getLogger(VM.class);
    private static final int VM_STACK_MAX_SIZE = 512;
    private static final BigInteger TEN_THOUSAND = new BigInteger("10000");
    public static final int MAX_GAS = 10000000;
    public final VMStack vmStack;
    public final Heap heap;
    public final MethodArea methodArea;
    private Result result;
    private Object resultValue;
    private VMContext vmContext;
    private ProgramInvoke programInvoke;
    private ProgramContext programContext;
    private ProgramExecutorImpl programExecutor;
    private Repository repository;
    private long gasUsed;
    private long gas;
    private long startTime;
    private long endTime;
    private long elapsedTime;
    private List<ProgramTransfer> transfers = new ArrayList<ProgramTransfer>();
    private List<ProgramInternalCall> internalCalls = new ArrayList<ProgramInternalCall>();
    private List<String> events = new ArrayList<String>();
    private List<String> debugEvents = new ArrayList<String>();
    private List<ProgramInvokeRegisterCmd> invokeRegisterCmds = new ArrayList<ProgramInvokeRegisterCmd>();
    private List<Object> orderedInnerTxs = new ArrayList<Object>();
    private LinkedList<String> stackTraces = new LinkedList();
    private List<ProgramInternalCreate> internalCreates = new ArrayList<ProgramInternalCreate>();
    private static final String CLASS_NAME = "java/util/HashMap";
    private static final String METHOD_NAME = "resize";
    private static final String METHOD_DESC = "()[Ljava/util/HashMap$Node;";

    public List<ProgramInternalCreate> getInternalCreates() {
        return this.internalCreates;
    }

    public LinkedList<String> getStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(LinkedList<String> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public VM() {
        this.vmStack = new VMStack(512);
        this.heap = new Heap(BigInteger.ZERO);
        this.heap.setVm(this);
        this.methodArea = new MethodArea();
        this.methodArea.setVm(this);
        this.result = new Result();
    }

    public VM(VM vm) {
        this.vmStack = new VMStack(512);
        if (vm.heap.getObjectRefCount().compareTo(TEN_THOUSAND) > 0) {
            throw new RuntimeException();
        }
        this.heap = new Heap(TEN_THOUSAND);
        this.heap.setVm(this);
        this.methodArea = new MethodArea();
        this.methodArea.setVm(this);
        this.result = new Result();
    }

    public VM(Heap heap, MethodArea methodArea) {
        this.vmStack = new VMStack(512);
        this.heap = heap;
        this.heap.setVm(this);
        this.methodArea = methodArea;
        this.methodArea.setVm(this);
        this.result = new Result();
    }

    public boolean isEmptyFrame() {
        return this.vmStack.isEmpty();
    }

    public boolean isNotEmptyFrame() {
        return !this.isEmptyFrame();
    }

    public Frame lastFrame() {
        return (Frame)this.vmStack.lastElement();
    }

    public void popFrame() {
        this.vmStack.pop();
    }

    public void endTime() {
        this.endTime = System.currentTimeMillis();
        this.elapsedTime = this.endTime - this.startTime;
    }

    public void initProgramContext(ProgramInvoke programInvoke) {
        this.programInvoke = programInvoke;
        this.programContext = new ProgramContext();
        this.programContext.setAddress(this.heap.newAddress(programInvoke.getAddress()));
        if (programInvoke.getSender() != null) {
            this.programContext.setSender(this.heap.newAddress(NativeAddress.toString(programInvoke.getSender())));
        }
        this.programContext.setGasPrice(programInvoke.getPrice());
        this.programContext.setGas(programInvoke.getGasLimit());
        this.programContext.setValue(this.heap.newBigInteger(programInvoke.getValue().toString()));
        List<ProgramMultyAssetValue> multyAssetValues = programInvoke.getMultyAssetValues();
        if (multyAssetValues != null && !multyAssetValues.isEmpty()) {
            this.programContext.setMultyAssetValues(this.heap.multyAssetValueArrayToObjectRef(multyAssetValues));
        }
        this.programContext.setNumber(programInvoke.getNumber());
        this.programContext.setEstimateGas(programInvoke.isEstimateGas());
        if (programInvoke.getSenderPublicKey() != null) {
            this.programContext.setSenderPublicKey(this.heap.newString(HexUtil.encode((byte[])programInvoke.getSenderPublicKey())));
        }
    }

    public void run(MethodCode methodCode, Object[] args, boolean pushResult) {
        Frame frame = new Frame(this, methodCode, args);
        if (methodCode.isMethod(CLASS_NAME, METHOD_NAME, METHOD_DESC)) {
            frame.setAddGas(false);
        }
        this.vmStack.push(frame);
        this.run(pushResult);
        if (!frame.addGas) {
            frame.setAddGas(true);
        }
    }

    public void run(ObjectRef objectRef, MethodCode methodCode, VMContext vmContext, ProgramInvoke programInvoke) {
        this.vmContext = vmContext;
        Object[] runArgs = this.runArgs(objectRef, methodCode, programInvoke.getArgs());
        if (this.isEnd()) {
            return;
        }
        this.initProgramContext(programInvoke);
        this.run(methodCode, runArgs, true);
    }

    private Object[] runArgs(ObjectRef objectRef, MethodCode methodCode, String[][] args) {
        ArrayList<Object> runArgs = new ArrayList<Object>();
        runArgs.add(objectRef);
        List<VariableType> argsVariableType = methodCode.argsVariableType;
        int size = argsVariableType.size();
        if ("_payable".equals(methodCode.name) && "([[Ljava/lang/String;)V".equals(methodCode.desc)) {
            ProgramMethodArg programMethodArg = methodCode.args.get(0);
            if (args == null || args.length == 0) {
                throw new RuntimeException(String.format("parameter %s required", programMethodArg.getName()));
            }
            ObjectRef twoDimensionalArrayRef = this.heap.stringTwoDimensionalArrayToObjectRef(args);
            runArgs.add(twoDimensionalArrayRef);
            return runArgs.toArray();
        }
        for (int i = 0; i < size; ++i) {
            ObjectRef ref;
            VariableType variableType = argsVariableType.get(i);
            ProgramMethodArg programMethodArg = methodCode.args.get(i);
            String[] arg = args[i];
            String realArg = null;
            if (arg != null && arg.length > 0) {
                realArg = arg[0];
            }
            if (programMethodArg.isRequired() && (arg == null || arg.length < 1 || !variableType.isArray() && StringUtils.isEmpty((CharSequence)realArg))) {
                throw new RuntimeException(String.format("parameter %s required", programMethodArg.getName()));
            }
            if (arg == null || arg.length == 0) {
                runArgs.add(null);
                continue;
            }
            if (variableType.isArray()) {
                ObjectRef ref2;
                ObjectRef arrayRef;
                String item;
                if (arg.length < 1) {
                    runArgs.add(null);
                    continue;
                }
                if (variableType.isPrimitiveType()) {
                    Object array = Array.newInstance(variableType.getComponentType().getPrimitiveTypeClass(), arg.length);
                    for (int j = 0; j < arg.length; ++j) {
                        item = arg[j];
                        Object value = variableType.getComponentType().getPrimitiveValue(item);
                        Array.set(array, j, value);
                    }
                    ObjectRef ref3 = this.heap.newArray(array, variableType, arg.length);
                    runArgs.add(ref3);
                    continue;
                }
                if (variableType.getComponentType().isWrapperType()) {
                    arrayRef = this.heap.newArray(variableType, arg.length);
                    for (int j = 0; j < arg.length; ++j) {
                        item = arg[j];
                        if (item == null) continue;
                        ref2 = VariableType.CHAR_WRAPPER_TYPE.equals(variableType.getComponentType()) ? this.heap.newCharacter(item.charAt(0)) : this.heap.runNewObject(variableType.getComponentType(), item);
                        if (this.isEnd()) {
                            return null;
                        }
                        this.heap.putArray(arrayRef, j, ref2);
                    }
                    runArgs.add(arrayRef);
                    continue;
                }
                arrayRef = this.heap.newArray(VariableType.STRING_ARRAY_TYPE, arg.length);
                for (int j = 0; j < arg.length; ++j) {
                    item = arg[j];
                    ref2 = this.heap.newString(item);
                    this.heap.putArray(arrayRef, j, ref2);
                }
                runArgs.add(arrayRef);
                continue;
            }
            if (variableType.isPrimitive()) {
                Object primitiveValue = variableType.getPrimitiveValue(realArg);
                runArgs.add(primitiveValue);
                if (!variableType.isLong() && !variableType.isDouble()) continue;
                runArgs.add(null);
                continue;
            }
            if (VariableType.STRING_TYPE.equals(variableType)) {
                ref = this.heap.newString(realArg);
                runArgs.add(ref);
                continue;
            }
            ref = this.heap.runNewObject(variableType, realArg);
            if (this.isEnd()) {
                return null;
            }
            runArgs.add(ref);
        }
        return runArgs.toArray();
    }

    public void run(boolean pushResult) {
        if (this.startTime < 1L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.result.isError()) {
            this.endTime();
            return;
        }
        if (!this.vmStack.isEmpty()) {
            Frame frame = (Frame)this.vmStack.lastElement();
            while (frame.getCurrentInsnNode() != null && !frame.result.isEnded()) {
                this.step(frame);
                frame.step();
                if (this.isEnd()) {
                    return;
                }
                if (frame == this.vmStack.lastElement()) continue;
                this.endTime();
                return;
            }
            this.popFrame();
            this.resultValue = frame.result.getValue();
            if (!this.vmStack.isEmpty()) {
                Frame lastFrame = (Frame)this.vmStack.lastElement();
                if (frame.result.getVariableType().isNotVoid() && pushResult) {
                    lastFrame.operandStack.push(frame.result.getValue(), frame.result.getVariableType());
                }
            } else {
                this.result = frame.result;
            }
        }
        this.endTime();
    }

    private boolean isEnd() {
        if (this.result.isError()) {
            this.endTime();
            return true;
        }
        if (this.result.isException()) {
            this.endTime();
            return true;
        }
        return false;
    }

    private void step(Frame frame) {
        OpCode opCode = frame.currentOpCode();
        if (opCode == null) {
            if (frame.getCurrentInsnNode() != null && frame.getCurrentInsnNode().getOpcode() >= 0) {
                frame.nonsupportOpCode();
            }
            return;
        }
        if (frame.addGas) {
            int gasCost = this.gasCost(frame, opCode);
            this.addGasUsed(gasCost);
        }
        switch (opCode) {
            case NOP: {
                break;
            }
            case ACONST_NULL: {
                frame.operandStack.pushRef(null);
                break;
            }
            case ICONST_M1: {
                frame.operandStack.pushInt(-1);
                break;
            }
            case ICONST_0: {
                frame.operandStack.pushInt(0);
                break;
            }
            case ICONST_1: {
                frame.operandStack.pushInt(1);
                break;
            }
            case ICONST_2: {
                frame.operandStack.pushInt(2);
                break;
            }
            case ICONST_3: {
                frame.operandStack.pushInt(3);
                break;
            }
            case ICONST_4: {
                frame.operandStack.pushInt(4);
                break;
            }
            case ICONST_5: {
                frame.operandStack.pushInt(5);
                break;
            }
            case LCONST_0: {
                frame.operandStack.pushLong(0L);
                break;
            }
            case LCONST_1: {
                frame.operandStack.pushLong(1L);
                break;
            }
            case FCONST_0: {
                frame.operandStack.pushFloat(0.0f);
                break;
            }
            case FCONST_1: {
                frame.operandStack.pushFloat(1.0f);
                break;
            }
            case FCONST_2: {
                frame.operandStack.pushFloat(2.0f);
                break;
            }
            case DCONST_0: {
                frame.operandStack.pushDouble(0.0);
                break;
            }
            case DCONST_1: {
                frame.operandStack.pushDouble(1.0);
                break;
            }
            case BIPUSH: {
                frame.operandStack.pushInt(frame.intInsnNode().operand);
                break;
            }
            case SIPUSH: {
                frame.operandStack.pushInt(frame.intInsnNode().operand);
                break;
            }
            case LDC: {
                Ldc.ldc(frame);
                break;
            }
            case ILOAD: {
                Iload.iload(frame);
                break;
            }
            case LLOAD: {
                Lload.lload(frame);
                break;
            }
            case FLOAD: {
                Fload.fload(frame);
                break;
            }
            case DLOAD: {
                Dload.dload(frame);
                break;
            }
            case ALOAD: {
                Aload.aload(frame);
                break;
            }
            case IALOAD: {
                Xaload.iaload(frame);
                break;
            }
            case LALOAD: {
                Xaload.laload(frame);
                break;
            }
            case FALOAD: {
                Xaload.faload(frame);
                break;
            }
            case DALOAD: {
                Xaload.daload(frame);
                break;
            }
            case AALOAD: {
                Xaload.aaload(frame);
                break;
            }
            case BALOAD: {
                Xaload.baload(frame);
                break;
            }
            case CALOAD: {
                Xaload.caload(frame);
                break;
            }
            case SALOAD: {
                Xaload.saload(frame);
                break;
            }
            case ISTORE: {
                Istore.istore(frame);
                break;
            }
            case LSTORE: {
                Lstore.lstore(frame);
                break;
            }
            case FSTORE: {
                Fstore.fstore(frame);
                break;
            }
            case DSTORE: {
                Dstore.dstore(frame);
                break;
            }
            case ASTORE: {
                Astore.astore(frame);
                break;
            }
            case IASTORE: {
                Xastore.iastore(frame);
                break;
            }
            case LASTORE: {
                Xastore.lastore(frame);
                break;
            }
            case FASTORE: {
                Xastore.fastore(frame);
                break;
            }
            case DASTORE: {
                Xastore.dastore(frame);
                break;
            }
            case AASTORE: {
                Xastore.aastore(frame);
                break;
            }
            case BASTORE: {
                Xastore.bastore(frame);
                break;
            }
            case CASTORE: {
                Xastore.castore(frame);
                break;
            }
            case SASTORE: {
                Xastore.sastore(frame);
                break;
            }
            case POP: {
                Pop.pop(frame);
                break;
            }
            case POP2: {
                Pop.pop2(frame);
                break;
            }
            case DUP: {
                Dup.dup(frame);
                break;
            }
            case DUP_X1: {
                Dup.dup_x1(frame);
                break;
            }
            case DUP_X2: {
                Dup.dup_x2(frame);
                break;
            }
            case DUP2: {
                Dup.dup2(frame);
                break;
            }
            case DUP2_X1: {
                Dup.dup2_x1(frame);
                break;
            }
            case DUP2_X2: {
                Dup.dup2_x2(frame);
                break;
            }
            case SWAP: {
                Swap.swap(frame);
                break;
            }
            case IADD: {
                Add.iadd(frame);
                break;
            }
            case LADD: {
                Add.ladd(frame);
                break;
            }
            case FADD: {
                Add.fadd(frame);
                break;
            }
            case DADD: {
                Add.dadd(frame);
                break;
            }
            case ISUB: {
                Sub.isub(frame);
                break;
            }
            case LSUB: {
                Sub.lsub(frame);
                break;
            }
            case FSUB: {
                Sub.fsub(frame);
                break;
            }
            case DSUB: {
                Sub.dsub(frame);
                break;
            }
            case IMUL: {
                Mul.imul(frame);
                break;
            }
            case LMUL: {
                Mul.lmul(frame);
                break;
            }
            case FMUL: {
                Mul.fmul(frame);
                break;
            }
            case DMUL: {
                Mul.dmul(frame);
                break;
            }
            case IDIV: {
                Div.idiv(frame);
                break;
            }
            case LDIV: {
                Div.ldiv(frame);
                break;
            }
            case FDIV: {
                Div.fdiv(frame);
                break;
            }
            case DDIV: {
                Div.ddiv(frame);
                break;
            }
            case IREM: {
                Rem.irem(frame);
                break;
            }
            case LREM: {
                Rem.lrem(frame);
                break;
            }
            case FREM: {
                Rem.frem(frame);
                break;
            }
            case DREM: {
                Rem.drem(frame);
                break;
            }
            case INEG: {
                Neg.ineg(frame);
                break;
            }
            case LNEG: {
                Neg.lneg(frame);
                break;
            }
            case FNEG: {
                Neg.fneg(frame);
                break;
            }
            case DNEG: {
                Neg.dneg(frame);
                break;
            }
            case ISHL: {
                Shl.ishl(frame);
                break;
            }
            case LSHL: {
                Shl.lshl(frame);
                break;
            }
            case ISHR: {
                Shr.ishr(frame);
                break;
            }
            case LSHR: {
                Shr.lshr(frame);
                break;
            }
            case IUSHR: {
                Ushr.iushr(frame);
                break;
            }
            case LUSHR: {
                Ushr.lushr(frame);
                break;
            }
            case IAND: {
                And.iand(frame);
                break;
            }
            case LAND: {
                And.land(frame);
                break;
            }
            case IOR: {
                Or.ior(frame);
                break;
            }
            case LOR: {
                Or.lor(frame);
                break;
            }
            case IXOR: {
                Xor.ixor(frame);
                break;
            }
            case LXOR: {
                Xor.lxor(frame);
                break;
            }
            case IINC: {
                Iinc.iinc(frame);
                break;
            }
            case I2L: {
                I2x.i2l(frame);
                break;
            }
            case I2F: {
                I2x.i2f(frame);
                break;
            }
            case I2D: {
                I2x.i2d(frame);
                break;
            }
            case L2I: {
                L2x.l2i(frame);
                break;
            }
            case L2F: {
                L2x.l2f(frame);
                break;
            }
            case L2D: {
                L2x.l2d(frame);
                break;
            }
            case F2I: {
                F2x.f2i(frame);
                break;
            }
            case F2L: {
                F2x.f2l(frame);
                break;
            }
            case F2D: {
                F2x.f2d(frame);
                break;
            }
            case D2I: {
                D2x.d2i(frame);
                break;
            }
            case D2L: {
                D2x.d2l(frame);
                break;
            }
            case D2F: {
                D2x.d2f(frame);
                break;
            }
            case I2B: {
                I2x.i2b(frame);
                break;
            }
            case I2C: {
                I2x.i2c(frame);
                break;
            }
            case I2S: {
                I2x.i2s(frame);
                break;
            }
            case LCMP: {
                Lcmp.lcmp(frame);
                break;
            }
            case FCMPL: {
                Fcmp.fcmpl(frame);
                break;
            }
            case FCMPG: {
                Fcmp.fcmpg(frame);
                break;
            }
            case DCMPL: {
                Dcmp.dcmpl(frame);
                break;
            }
            case DCMPG: {
                Dcmp.dcmpg(frame);
                break;
            }
            case IFEQ: {
                IfCmp.ifeq(frame);
                break;
            }
            case IFNE: {
                IfCmp.ifne(frame);
                break;
            }
            case IFLT: {
                IfCmp.iflt(frame);
                break;
            }
            case IFGE: {
                IfCmp.ifge(frame);
                break;
            }
            case IFGT: {
                IfCmp.ifgt(frame);
                break;
            }
            case IFLE: {
                IfCmp.ifle(frame);
                break;
            }
            case IF_ICMPEQ: {
                IfIcmp.if_icmpeq(frame);
                break;
            }
            case IF_ICMPNE: {
                IfIcmp.if_icmpne(frame);
                break;
            }
            case IF_ICMPLT: {
                IfIcmp.if_icmplt(frame);
                break;
            }
            case IF_ICMPGE: {
                IfIcmp.if_icmpge(frame);
                break;
            }
            case IF_ICMPGT: {
                IfIcmp.if_icmpgt(frame);
                break;
            }
            case IF_ICMPLE: {
                IfIcmp.if_icmple(frame);
                break;
            }
            case IF_ACMPEQ: {
                IfAcmp.if_acmpeq(frame);
                break;
            }
            case IF_ACMPNE: {
                IfAcmp.if_acmpne(frame);
                break;
            }
            case GOTO: {
                Goto.goto_(frame);
                break;
            }
            case JSR: {
                Jsr.jsr(frame);
                break;
            }
            case RET: {
                Ret.ret(frame);
                break;
            }
            case TABLESWITCH: {
                Tableswitch.tableswitch(frame);
                break;
            }
            case LOOKUPSWITCH: {
                Lookupswitch.lookupswitch(frame);
                break;
            }
            case IRETURN: {
                Return.ireturn(frame);
                break;
            }
            case LRETURN: {
                Return.lreturn(frame);
                break;
            }
            case FRETURN: {
                Return.freturn(frame);
                break;
            }
            case DRETURN: {
                Return.dreturn(frame);
                break;
            }
            case ARETURN: {
                Return.areturn(frame);
                break;
            }
            case RETURN: {
                Return.return_(frame);
                break;
            }
            case GETSTATIC: {
                Getstatic.getstatic(frame);
                break;
            }
            case PUTSTATIC: {
                Putstatic.putstatic(frame);
                break;
            }
            case GETFIELD: {
                Getfield.getfield(frame);
                break;
            }
            case PUTFIELD: {
                Putfield.putfield(frame);
                break;
            }
            case INVOKEVIRTUAL: {
                Invokevirtual.invokevirtual(frame);
                break;
            }
            case INVOKESPECIAL: {
                Invokespecial.invokespecial(frame);
                break;
            }
            case INVOKESTATIC: {
                Invokestatic.invokestatic(frame);
                break;
            }
            case INVOKEINTERFACE: {
                Invokeinterface.invokeinterface(frame);
                break;
            }
            case INVOKEDYNAMIC: {
                Invokedynamic.invokedynamic(frame);
                break;
            }
            case NEW: {
                New.new_(frame);
                break;
            }
            case NEWARRAY: {
                Newarray.newarray(frame);
                break;
            }
            case ANEWARRAY: {
                Anewarray.anewarray(frame);
                break;
            }
            case ARRAYLENGTH: {
                Arraylength.arraylength(frame);
                break;
            }
            case ATHROW: {
                Athrow.athrow(frame);
                break;
            }
            case CHECKCAST: {
                Checkcast.checkcast(frame);
                break;
            }
            case INSTANCEOF: {
                Instanceof.instanceof_(frame);
                break;
            }
            case MONITORENTER: {
                Monitorenter.monitorenter(frame);
                break;
            }
            case MONITOREXIT: {
                Monitorexit.monitorexit(frame);
                break;
            }
            case MULTIANEWARRAY: {
                Multianewarray.multianewarray(frame);
                break;
            }
            case IFNULL: {
                Ifnull.ifnull(frame);
                break;
            }
            case IFNONNULL: {
                Ifnonnull.ifnonnull(frame);
                break;
            }
            default: {
                frame.nonsupportOpCode();
            }
        }
    }

    public int gasCost(Frame frame, OpCode opCode) {
        int gasCost = 1;
        switch (opCode) {
            case NOP: {
                break;
            }
            case ACONST_NULL: 
            case ICONST_M1: 
            case ICONST_0: 
            case ICONST_1: 
            case ICONST_2: 
            case ICONST_3: 
            case ICONST_4: 
            case ICONST_5: 
            case LCONST_0: 
            case LCONST_1: 
            case FCONST_0: 
            case FCONST_1: 
            case FCONST_2: 
            case DCONST_0: 
            case DCONST_1: 
            case BIPUSH: 
            case SIPUSH: {
                gasCost = 1;
                break;
            }
            case LDC: {
                Object value = frame.ldcInsnNode().cst;
                if (value instanceof Number) {
                    gasCost = 1;
                    break;
                }
                gasCost = Math.max(value.toString().length(), 1) * 1;
                break;
            }
            case ILOAD: 
            case LLOAD: 
            case FLOAD: 
            case DLOAD: 
            case ALOAD: {
                gasCost = 1;
                break;
            }
            case IALOAD: 
            case LALOAD: 
            case FALOAD: 
            case DALOAD: 
            case AALOAD: 
            case BALOAD: 
            case CALOAD: 
            case SALOAD: {
                gasCost = 5;
                break;
            }
            case ISTORE: 
            case LSTORE: 
            case FSTORE: 
            case DSTORE: 
            case ASTORE: {
                gasCost = 1;
                break;
            }
            case IASTORE: 
            case LASTORE: 
            case FASTORE: 
            case DASTORE: 
            case AASTORE: 
            case BASTORE: 
            case CASTORE: 
            case SASTORE: {
                gasCost = 5;
                break;
            }
            case POP: 
            case POP2: 
            case DUP: 
            case DUP_X1: 
            case DUP_X2: 
            case DUP2: 
            case DUP2_X1: 
            case DUP2_X2: 
            case SWAP: {
                gasCost = 2;
                break;
            }
            case IADD: 
            case LADD: 
            case FADD: 
            case DADD: 
            case ISUB: 
            case LSUB: 
            case FSUB: 
            case DSUB: 
            case IMUL: 
            case LMUL: 
            case FMUL: 
            case DMUL: 
            case IDIV: 
            case LDIV: 
            case FDIV: 
            case DDIV: 
            case IREM: 
            case LREM: 
            case FREM: 
            case DREM: 
            case INEG: 
            case LNEG: 
            case FNEG: 
            case DNEG: 
            case ISHL: 
            case LSHL: 
            case ISHR: 
            case LSHR: 
            case IUSHR: 
            case LUSHR: 
            case IAND: 
            case LAND: 
            case IOR: 
            case LOR: 
            case IXOR: 
            case LXOR: 
            case IINC: {
                gasCost = 1;
                break;
            }
            case I2L: 
            case I2F: 
            case I2D: 
            case L2I: 
            case L2F: 
            case L2D: 
            case F2I: 
            case F2L: 
            case F2D: 
            case D2I: 
            case D2L: 
            case D2F: 
            case I2B: 
            case I2C: 
            case I2S: {
                gasCost = 1;
                break;
            }
            case LCMP: 
            case FCMPL: 
            case FCMPG: 
            case DCMPL: 
            case DCMPG: 
            case IFEQ: 
            case IFNE: 
            case IFLT: 
            case IFGE: 
            case IFGT: 
            case IFLE: 
            case IF_ICMPEQ: 
            case IF_ICMPNE: 
            case IF_ICMPLT: 
            case IF_ICMPGE: 
            case IF_ICMPGT: 
            case IF_ICMPLE: 
            case IF_ACMPEQ: 
            case IF_ACMPNE: {
                gasCost = 1;
                break;
            }
            case GOTO: 
            case JSR: 
            case RET: {
                gasCost = 5;
                break;
            }
            case TABLESWITCH: {
                TableSwitchInsnNode table = frame.tableSwitchInsnNode();
                gasCost = Math.max(table.max - table.min, 1) * 2;
                break;
            }
            case LOOKUPSWITCH: {
                LookupSwitchInsnNode lookup = frame.lookupSwitchInsnNode();
                gasCost = Math.max(lookup.keys.size(), 1) * 2;
                break;
            }
            case IRETURN: 
            case LRETURN: 
            case FRETURN: 
            case DRETURN: 
            case ARETURN: 
            case RETURN: {
                gasCost = 5;
                break;
            }
            case GETSTATIC: 
            case PUTSTATIC: 
            case GETFIELD: 
            case PUTFIELD: 
            case INVOKEVIRTUAL: 
            case INVOKESPECIAL: 
            case INVOKESTATIC: 
            case INVOKEINTERFACE: 
            case INVOKEDYNAMIC: 
            case NEW: {
                gasCost = 10;
                break;
            }
            case NEWARRAY: 
            case ANEWARRAY: {
                int count = frame.operandStack.popInt();
                gasCost = Math.max(count, 1) * 1;
                frame.operandStack.pushInt(count);
                break;
            }
            case ARRAYLENGTH: 
            case ATHROW: 
            case CHECKCAST: 
            case INSTANCEOF: 
            case MONITORENTER: 
            case MONITOREXIT: {
                gasCost = 10;
                break;
            }
            case MULTIANEWARRAY: {
                MultiANewArrayInsnNode multiANewArrayInsnNode = frame.multiANewArrayInsnNode();
                int size = 1;
                int[] dimensions = new int[multiANewArrayInsnNode.dims];
                for (int i = multiANewArrayInsnNode.dims - 1; i >= 0; --i) {
                    int length = frame.operandStack.popInt();
                    if (length > 0) {
                        size *= length;
                    }
                    dimensions[i] = length;
                }
                for (int dimension : dimensions) {
                    frame.operandStack.pushInt(dimension);
                }
                gasCost = size * 1;
                break;
            }
            case IFNULL: 
            case IFNONNULL: {
                gasCost = 1;
                break;
            }
        }
        return gasCost;
    }

    public BlockHeaderDto getBlockHeader(long number) {
        if (this.vmContext != null) {
            BlockHeaderDto blockHeader;
            try {
                int chainId = this.programExecutor.getCurrentChainId();
                blockHeader = number == this.programInvoke.getNumber() + 1L ? this.vmContext.getCurrentBlockHeader(chainId) : this.vmContext.getBlockHeader(chainId, number);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (blockHeader == null) {
                this.log.error(String.format("blockHeader is null, number: %s", number));
            }
            return blockHeader;
        }
        throw new RuntimeException(String.format("vmContext is null, number: %s", number));
    }

    public int getCrossAssetsDecimals(int assetChainId, int assetId) {
        if (this.vmContext != null) {
            return this.vmContext.getCrossAssetsDecimals(assetChainId, assetId);
        }
        throw new RuntimeException(String.format("vmContext is null, parms: %s, %s", assetChainId, assetId));
    }

    public String getRandomSeed(long endHeight, int count, String algorithm) {
        if (this.vmContext != null) {
            String seed;
            try {
                seed = this.vmContext.getRandomSeed(this.programExecutor.getCurrentChainId(), endHeight, count, algorithm);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (seed == null) {
                this.log.error(String.format("seed is null, endHeight: %s, count: %s, algorithm: %s, ", endHeight, count, algorithm));
            }
            return seed;
        }
        throw new RuntimeException(String.format("vmContext is null", new Object[0]));
    }

    public String getRandomSeed(long startHeight, long endHeight, String algorithm) {
        if (this.vmContext != null) {
            String seed;
            try {
                seed = this.vmContext.getRandomSeed(this.programExecutor.getCurrentChainId(), startHeight, endHeight, algorithm);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (seed == null) {
                this.log.error(String.format("seed is null, startHeight: %s, endHeight: %s, algorithm: %s, ", startHeight, endHeight, algorithm));
            }
            return seed;
        }
        throw new RuntimeException(String.format("vmContext is null", new Object[0]));
    }

    public List<String> getRandomSeedList(long endHeight, int seedCount) {
        if (this.vmContext != null) {
            List<String> seeds;
            try {
                seeds = this.vmContext.getRandomSeedList(this.programExecutor.getCurrentChainId(), endHeight, seedCount);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (seeds.isEmpty()) {
                this.log.error(String.format("seeds is empty, endHeight: %s, seedCount: %s", endHeight, seedCount));
            }
            return seeds;
        }
        throw new RuntimeException(String.format("vmContext is null", new Object[0]));
    }

    public List<String> getRandomSeedList(long startHeight, long endHeight) {
        if (this.vmContext != null) {
            List<String> seeds;
            try {
                seeds = this.vmContext.getRandomSeedList(this.programExecutor.getCurrentChainId(), startHeight, endHeight);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (seeds.isEmpty()) {
                this.log.error(String.format("seeds is empty, startHeight: %s, endHeight: %s", startHeight, endHeight));
            }
            return seeds;
        }
        throw new RuntimeException(String.format("vmContext is null", new Object[0]));
    }

    public Result getResult() {
        return this.result;
    }

    public String getResultString() {
        String result = null;
        Object resultValue = this.getResult().getValue();
        if (resultValue != null) {
            if (resultValue instanceof ObjectRef) {
                if (this.getResult().isError() || this.getResult().isException()) {
                    this.setResult(new Result());
                }
                result = this.heap.runToString((ObjectRef)resultValue);
            } else {
                result = resultValue.toString();
            }
        }
        return result;
    }

    public Object getResultValue() {
        return this.resultValue;
    }

    public VMContext getVmContext() {
        return this.vmContext;
    }

    public ProgramInvoke getProgramInvoke() {
        return this.programInvoke;
    }

    public ProgramContext getProgramContext() {
        return this.programContext;
    }

    public ProgramExecutorImpl getProgramExecutor() {
        return this.programExecutor;
    }

    public long getGasUsed() {
        return this.gasUsed;
    }

    public long getGas() {
        return this.gas;
    }

    public long getGasLeft() {
        return this.gas - this.gasUsed;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public List<ProgramTransfer> getTransfers() {
        return this.transfers;
    }

    public List<ProgramInternalCall> getInternalCalls() {
        return this.internalCalls;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public List<String> getDebugEvents() {
        return this.debugEvents;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public List<ProgramInvokeRegisterCmd> getInvokeRegisterCmds() {
        return this.invokeRegisterCmds;
    }

    public void setInvokeRegisterCmds(List<ProgramInvokeRegisterCmd> invokeRegisterCmds) {
        this.invokeRegisterCmds = invokeRegisterCmds;
    }

    public List<Object> getOrderedInnerTxs() {
        return this.orderedInnerTxs;
    }

    public void setOrderedInnerTxs(List<Object> orderedInnerTxs) {
        this.orderedInnerTxs = orderedInnerTxs;
    }

    public void setProgramExecutor(ProgramExecutorImpl programExecutor) {
        this.programExecutor = programExecutor;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void addGasUsed(long needGas) {
        long gasUsed = this.gasUsed + needGas;
        if (this.gas > 0L && gasUsed > this.gas) {
            this.gasUsed = this.gas;
            throw new ErrorException("not enough gas", this.gasUsed, null);
        }
        this.gasUsed = gasUsed;
    }

    public void setGas(long gas) {
        this.gas = gas;
    }

    public Set<String> getAssetsAbountContractRewardLogByConsensus(int chainId, byte[] address) {
        if (this.vmContext != null) {
            return this.vmContext.getAssetsAbountContractRewardLogByConsensus(chainId, address);
        }
        throw new RuntimeException(String.format("vmContext is null, parms: %s, %s", chainId, address));
    }

    public BigInteger getAssetAmountAbountContractRewardLogByConsensus(int chainId, byte[] address, int assetChainId, int assetId) {
        if (this.vmContext != null) {
            return this.vmContext.getAssetAmountAbountContractRewardLogByConsensus(chainId, address, assetChainId, assetId);
        }
        throw new RuntimeException(String.format("vmContext is null, parms: %s, %s, %s, %s", chainId, address, assetChainId, assetId));
    }
}

