/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.loads;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;

public class Xaload {
    public static void iaload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        int value = (Integer)frame.heap.getArray(arrayRef, index);
        frame.operandStack.pushInt(value);
    }

    public static void laload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        long value = (Long)frame.heap.getArray(arrayRef, index);
        frame.operandStack.pushLong(value);
    }

    public static void faload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        float value = ((Float)frame.heap.getArray(arrayRef, index)).floatValue();
        frame.operandStack.pushFloat(value);
    }

    public static void daload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        double value = (Double)frame.heap.getArray(arrayRef, index);
        frame.operandStack.pushDouble(value);
    }

    public static void aaload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        ObjectRef value = (ObjectRef)frame.heap.getArray(arrayRef, index);
        frame.operandStack.pushRef(value);
    }

    public static void baload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        if (arrayRef.getVariableType().getComponentType().isBoolean()) {
            boolean value = (Boolean)frame.heap.getArray(arrayRef, index);
            frame.operandStack.pushBoolean(value);
            Boolean result = value;
        } else {
            byte value = (Byte)frame.heap.getArray(arrayRef, index);
            frame.operandStack.pushByte(value);
            Byte result = value;
        }
    }

    public static void caload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        char value = ((Character)frame.heap.getArray(arrayRef, index)).charValue();
        frame.operandStack.pushChar(value);
    }

    public static void saload(Frame frame) {
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        short value = (Short)frame.heap.getArray(arrayRef, index);
        frame.operandStack.pushShort(value);
    }
}

