/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.references;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.VariableType;
import java.util.ArrayList;
import java.util.Objects;
import org.objectweb.asm.tree.TypeInsnNode;

public class Instanceof {
    public static void instanceof_(Frame frame) {
        TypeInsnNode typeInsnNode = frame.typeInsnNode();
        VariableType variableType = VariableType.valueOf(typeInsnNode.desc);
        ObjectRef objectRef = frame.operandStack.popRef();
        boolean result = Instanceof.instanceof_(objectRef, variableType, frame);
        frame.operandStack.pushInt(result ? 1 : 0);
    }

    public static boolean instanceof_(ObjectRef objectRef, VariableType variableType, Frame frame) {
        boolean result = objectRef == null ? false : (Objects.equals("Ljava/lang/Object;", variableType.getDesc()) ? true : (objectRef.isArray() || variableType.isArray() ? (objectRef.isArray() && variableType.isArray() ? (objectRef.getDimensions().length == variableType.getDimensions() ? Instanceof.instanceof_(objectRef.getVariableType().getType(), variableType.getType(), frame) : false) : false) : Instanceof.instanceof_(objectRef.getVariableType().getType(), variableType.getType(), frame)));
        return result;
    }

    public static boolean instanceof_(String refType, String className, Frame frame) {
        if (Objects.equals(refType, className) || Objects.equals("java/lang/Object", className)) {
            return true;
        }
        if (Objects.equals("java/lang/Object", refType)) {
            return false;
        }
        ClassCode classCode = frame.methodArea.loadClass(refType);
        String superName = classCode.superName;
        ArrayList<String> list = new ArrayList<String>();
        list.add(superName);
        list.addAll(classCode.interfaces);
        for (String s : list) {
            boolean result = Instanceof.instanceof_(s, className, frame);
            if (!result) continue;
            return true;
        }
        return false;
    }
}

