/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.references;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.code.VariableType;

public class Newarray {
    public static void newarray(Frame frame) {
        VariableType type;
        int length = frame.operandStack.popInt();
        if (length < 0) {
            frame.throwNegativeArraySizeException();
            return;
        }
        switch (frame.intInsnNode().operand) {
            case 4: {
                type = VariableType.BOOLEAN_ARRAY_TYPE;
                break;
            }
            case 5: {
                type = VariableType.CHAR_ARRAY_TYPE;
                break;
            }
            case 6: {
                type = VariableType.FLOAT_ARRAY_TYPE;
                break;
            }
            case 7: {
                type = VariableType.DOUBLE_ARRAY_TYPE;
                break;
            }
            case 8: {
                type = VariableType.BYTE_ARRAY_TYPE;
                break;
            }
            case 9: {
                type = VariableType.SHORT_ARRAY_TYPE;
                break;
            }
            case 10: {
                type = VariableType.INT_ARRAY_TYPE;
                break;
            }
            case 11: {
                type = VariableType.LONG_ARRAY_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown operand");
            }
        }
        ObjectRef arrayRef = frame.heap.newArray(type, length);
        frame.operandStack.pushRef(arrayRef);
    }
}

