/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.io.nuls.contract.sdk;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.exception.ErrorException;
import io.nuls.contract.vm.natives.NativeMethod;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.contract.vm.program.ProgramInternalCall;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.ProgramTransfer;
import io.nuls.contract.vm.program.impl.ProgramInvoke;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NativeAddress {
    public static final String TYPE = "io/nuls/contract/sdk/Address";
    public static final String balance = "io/nuls/contract/sdk/Address.balance()Ljava/math/BigInteger;";
    public static final String balanceOfDesignatedAsset = "io/nuls/contract/sdk/Address.balance(II)Ljava/math/BigInteger;";
    public static final String totalBalance = "io/nuls/contract/sdk/Address.totalBalance()Ljava/math/BigInteger;";
    public static final String totalBalanceOfDesignatedAsset = "io/nuls/contract/sdk/Address.totalBalance(II)Ljava/math/BigInteger;";
    public static final String transfer = "io/nuls/contract/sdk/Address.transfer(Ljava/math/BigInteger;)V";
    public static final String transferLocked = "io/nuls/contract/sdk/Address.transferLocked(Ljava/math/BigInteger;J)V";
    public static final String transferOfDesignatedAsset = "io/nuls/contract/sdk/Address.transferLocked(Ljava/math/BigInteger;IIJ)V";
    public static final String call = "io/nuls/contract/sdk/Address.call(Ljava/lang/String;Ljava/lang/String;[[Ljava/lang/String;Ljava/math/BigInteger;)V";
    public static final String callWithReturnValue = "io/nuls/contract/sdk/Address.callWithReturnValue(Ljava/lang/String;Ljava/lang/String;[[Ljava/lang/String;Ljava/math/BigInteger;)Ljava/lang/String;";
    public static final String callWithReturnValueAndAssetInfo = "io/nuls/contract/sdk/Address.callWithReturnValue(Ljava/lang/String;Ljava/lang/String;[[Ljava/lang/String;Ljava/math/BigInteger;[Lio/nuls/contract/sdk/MultyAssetValue;)Ljava/lang/String;";
    public static final String valid = "io/nuls/contract/sdk/Address.valid(Ljava/lang/String;)V";
    public static final String isContract = "io/nuls/contract/sdk/Address.isContract()Z";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "io/nuls/contract/sdk/Address.balance()Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.balance(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.balance(II)Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.balanceOfDesignatedAsset(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.totalBalance()Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.totalBalance(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.totalBalance(II)Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.totalBalanceOfDesignatedAsset(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.transfer(Ljava/math/BigInteger;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.transfer(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.transferLocked(Ljava/math/BigInteger;J)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.transferLocked(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.transferLocked(Ljava/math/BigInteger;IIJ)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.transferOfDesignatedAsset(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.call(Ljava/lang/String;Ljava/lang/String;[[Ljava/lang/String;Ljava/math/BigInteger;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.call(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.callWithReturnValue(Ljava/lang/String;Ljava/lang/String;[[Ljava/lang/String;Ljava/math/BigInteger;)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.callWithReturnValue(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.callWithReturnValue(Ljava/lang/String;Ljava/lang/String;[[Ljava/lang/String;Ljava/math/BigInteger;[Lio/nuls/contract/sdk/MultyAssetValue;)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.callWithReturnValueAndAssetInfo(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.valid(Ljava/lang/String;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.valid(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Address.isContract()Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAddress.isContract(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static BigInteger balance(byte[] address, Frame frame) {
        return frame.vm.getProgramExecutor().getAccount(address, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID).getBalance();
    }

    private static BigInteger totalBalance(byte[] address, Frame frame) {
        return frame.vm.getProgramExecutor().getAccount(address, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID).getTotalBalance();
    }

    private static Result balance(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        String address = frame.heap.runToString(objectRef);
        BigInteger balance = NativeAddress.balance(NativeAddress.toBytes(address), frame);
        ObjectRef balanceRef = frame.heap.newBigInteger(balance.toString());
        Result result = NativeMethod.result(methodCode, balanceRef, frame);
        return result;
    }

    private static Result balanceOfDesignatedAsset(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        int assetChainId = (Integer)methodArgs.invokeArgs[0];
        int assetId = (Integer)methodArgs.invokeArgs[1];
        ObjectRef objectRef = methodArgs.objectRef;
        String address = frame.heap.runToString(objectRef);
        BigInteger balance = frame.vm.getProgramExecutor().getAccount(NativeAddress.toBytes(address), assetChainId, assetId).getBalance();
        ObjectRef balanceRef = frame.heap.newBigInteger(balance.toString());
        Result result = NativeMethod.result(methodCode, balanceRef, frame);
        return result;
    }

    private static Result totalBalance(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        String address = frame.heap.runToString(objectRef);
        BigInteger totalBalance = NativeAddress.totalBalance(NativeAddress.toBytes(address), frame);
        ObjectRef totalBalanceRef = frame.heap.newBigInteger(totalBalance.toString());
        Result result = NativeMethod.result(methodCode, totalBalanceRef, frame);
        return result;
    }

    private static Result totalBalanceOfDesignatedAsset(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        int assetChainId = (Integer)methodArgs.invokeArgs[0];
        int assetId = (Integer)methodArgs.invokeArgs[1];
        ObjectRef objectRef = methodArgs.objectRef;
        String address = frame.heap.runToString(objectRef);
        BigInteger totalBalance = frame.vm.getProgramExecutor().getAccount(NativeAddress.toBytes(address), assetChainId, assetId).getTotalBalance();
        ObjectRef totalBalanceRef = frame.heap.newBigInteger(totalBalance.toString());
        Result result = NativeMethod.result(methodCode, totalBalanceRef, frame);
        return result;
    }

    private static Result transfer(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        return NativeAddress.transferBase(methodCode, methodArgs, frame, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, 0L);
    }

    private static Result transferLocked(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        long lockedTime = (Long)methodArgs.invokeArgs[1];
        return NativeAddress.transferBase(methodCode, methodArgs, frame, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, lockedTime);
    }

    private static Result transferOfDesignatedAsset(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        int assetChainId = (Integer)methodArgs.invokeArgs[1];
        int assetId = (Integer)methodArgs.invokeArgs[2];
        long lockedTime = (Long)methodArgs.invokeArgs[3];
        return NativeAddress.transferBase(methodCode, methodArgs, frame, assetChainId, assetId, lockedTime);
    }

    private static Result transferBase(MethodCode methodCode, MethodArgs methodArgs, Frame frame, int assetChainId, int assetId, long lockedTime) {
        boolean mainAsset;
        byte[] to;
        ObjectRef addressRef = methodArgs.objectRef;
        ObjectRef valueRef = (ObjectRef)methodArgs.invokeArgs[0];
        String address = frame.heap.runToString(addressRef);
        BigInteger value = frame.heap.toBigInteger(valueRef);
        byte[] from = frame.vm.getProgramInvoke().getContractAddress();
        if (Arrays.equals(from, to = NativeAddress.toBytes(address))) {
            throw new ErrorException(String.format("Cannot transfer from %s to %s", NativeAddress.toString(from), address), frame.vm.getGasUsed(), null);
        }
        NativeAddress.checkBalance(from, assetChainId, assetId, value, frame);
        int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
        if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_22) {
            frame.vm.addGasUsed(20000L);
        } else {
            frame.vm.addGasUsed(1000L);
        }
        boolean bl = mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
        if (frame.heap.existContract(to)) {
            if (lockedTime > 0L) {
                throw new ErrorException(String.format("Cannot transfer the locked amount to the contract address %s", address), frame.vm.getGasUsed(), null);
            }
            String methodName = mainAsset ? "_payable" : "_payableMultyAsset";
            String methodDesc = "()V";
            String[][] args = null;
            if (!mainAsset) {
                ProgramMultyAssetValue[] multyAssetValues = new ProgramMultyAssetValue[]{new ProgramMultyAssetValue(value, assetChainId, assetId)};
                NativeAddress.call(address, methodName, methodDesc, args, BigInteger.ZERO, frame, multyAssetValues);
            } else {
                NativeAddress.call(address, methodName, methodDesc, args, value, frame, null);
            }
        } else {
            frame.vm.getProgramExecutor().getAccount(from, assetChainId, assetId).addBalance(value.negate());
            ProgramTransfer programTransfer = new ProgramTransfer(from, to, value, assetChainId, assetId, lockedTime);
            frame.vm.getTransfers().add(programTransfer);
            frame.vm.getOrderedInnerTxs().add(programTransfer);
        }
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result call(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        return NativeAddress.call(methodCode, methodArgs, frame, false, null);
    }

    private static Result callWithReturnValue(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        return NativeAddress.call(methodCode, methodArgs, frame, true, null);
    }

    private static Result callWithReturnValueAndAssetInfo(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef multyAssetValuesRef = (ObjectRef)methodArgs.invokeArgs[4];
        ProgramMultyAssetValue[] multyAssetValues = null;
        if (multyAssetValuesRef != null) {
            int length = multyAssetValuesRef.getDimensions()[0];
            multyAssetValues = new ProgramMultyAssetValue[length];
            for (int i = 0; i < length; ++i) {
                Object item = frame.heap.getArray(multyAssetValuesRef, i);
                if (item == null) {
                    throw new ErrorException(String.format("Empty elements in array", new Object[0]), frame.vm.getGasUsed(), null);
                }
                ObjectRef itemRef = (ObjectRef)item;
                ObjectRef value = (ObjectRef)frame.heap.getField(itemRef, "value");
                Integer assetChainId = (Integer)frame.heap.getField(itemRef, "assetChainId");
                if (assetChainId == null || assetChainId == 0) {
                    throw new ErrorException(String.format("Zero assetChainId", new Object[0]), frame.vm.getGasUsed(), null);
                }
                Integer assetId = (Integer)frame.heap.getField(itemRef, "assetId");
                if (assetId == null || assetId == 0) {
                    throw new ErrorException(String.format("Zero assetId", new Object[0]), frame.vm.getGasUsed(), null);
                }
                multyAssetValues[i] = new ProgramMultyAssetValue(frame.heap.toBigInteger(value), assetChainId, assetId);
            }
        }
        return NativeAddress.call(methodCode, methodArgs, frame, true, multyAssetValues);
    }

    private static Result call(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean returnResult, ProgramMultyAssetValue[] multyAssetValues) {
        ProgramResult programResult;
        ObjectRef addressRef = methodArgs.objectRef;
        ObjectRef methodNameRef = (ObjectRef)methodArgs.invokeArgs[0];
        ObjectRef methodDescRef = (ObjectRef)methodArgs.invokeArgs[1];
        ObjectRef argsRef = (ObjectRef)methodArgs.invokeArgs[2];
        ObjectRef valueRef = (ObjectRef)methodArgs.invokeArgs[3];
        String address = frame.heap.runToString(addressRef);
        String methodName = frame.heap.runToString(methodNameRef);
        String methodDesc = frame.heap.runToString(methodDescRef);
        String[][] args = NativeAddress.getArgs(argsRef, frame);
        BigInteger value = frame.heap.toBigInteger(valueRef);
        if (value == null) {
            value = BigInteger.ZERO;
        }
        if (!(programResult = NativeAddress.call(address, methodName, methodDesc, args, value, frame, multyAssetValues)).isSuccess()) {
            return new Result();
        }
        ObjectRef resultValue = null;
        if (returnResult && programResult.isSuccess()) {
            resultValue = frame.heap.newString(programResult.getResult());
        }
        Result result = NativeMethod.result(methodCode, resultValue, frame);
        return result;
    }

    private static String[][] getArgs(ObjectRef argsRef, Frame frame) {
        if (argsRef == null) {
            return null;
        }
        int length = argsRef.getDimensions()[0];
        String[][] array = new String[length][0];
        for (int i = 0; i < length; ++i) {
            ObjectRef objectRef = (ObjectRef)frame.heap.getArray(argsRef, i);
            String[] ss = (String[])frame.heap.getObject(objectRef);
            array[i] = ss;
        }
        return array;
    }

    public static ProgramResult call(String address, String methodName, String methodDesc, String[][] args, BigInteger value, Frame frame, ProgramMultyAssetValue[] multyAssetValues) {
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new ErrorException(String.format("amount less than zero, value=%s", value), frame.vm.getGasUsed(), null);
        }
        ProgramInvoke programInvoke = frame.vm.getProgramInvoke();
        ProgramCall programCall = new ProgramCall();
        programCall.setNumber(programInvoke.getNumber());
        programCall.setSender(programInvoke.getContractAddress());
        programCall.setValue(value != null ? value : BigInteger.ZERO);
        programCall.setMultyAssetValues(multyAssetValues != null ? List.of(multyAssetValues) : null);
        programCall.setGasLimit(programInvoke.getGasLimit() - frame.vm.getGasUsed());
        programCall.setPrice(programInvoke.getPrice());
        programCall.setContractAddress(NativeAddress.toBytes(address));
        programCall.setMethodName(methodName);
        programCall.setMethodDesc(methodDesc);
        programCall.setArgs(args);
        programCall.setEstimateGas(programInvoke.isEstimateGas());
        programCall.setViewMethod(programInvoke.isViewMethod());
        programCall.setInternalCall(true);
        if (programCall.getValue().compareTo(BigInteger.ZERO) > 0) {
            NativeAddress.checkBalance(programCall.getSender(), ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, programCall.getValue(), frame);
            frame.vm.getProgramExecutor().getAccount(programCall.getSender(), ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID).addBalance(programCall.getValue().negate());
            ProgramTransfer programTransfer = new ProgramTransfer(programCall.getSender(), programCall.getContractAddress(), programCall.getValue(), ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, 0L);
            frame.vm.getTransfers().add(programTransfer);
            frame.vm.getOrderedInnerTxs().add(programTransfer);
        }
        if (multyAssetValues != null && multyAssetValues.length > 0) {
            for (ProgramMultyAssetValue multyAssetValue : multyAssetValues) {
                int assetChainId = multyAssetValue.getAssetChainId();
                int assetId = multyAssetValue.getAssetId();
                NativeAddress.checkBalance(programCall.getSender(), assetChainId, assetId, multyAssetValue.getValue(), frame);
                frame.vm.getProgramExecutor().getAccount(programCall.getSender(), assetChainId, assetId).addBalance(multyAssetValue.getValue().negate());
                ProgramTransfer programTransfer = new ProgramTransfer(programCall.getSender(), programCall.getContractAddress(), multyAssetValue.getValue(), assetChainId, assetId, 0L);
                frame.vm.getTransfers().add(programTransfer);
                frame.vm.getOrderedInnerTxs().add(programTransfer);
            }
        }
        ProgramInternalCall programInternalCall = new ProgramInternalCall();
        programInternalCall.setSender(programCall.getSender());
        programInternalCall.setValue(programCall.getValue());
        programInternalCall.setMultyAssetValues(programCall.getMultyAssetValues());
        programInternalCall.setContractAddress(programCall.getContractAddress());
        programInternalCall.setMethodName(programCall.getMethodName());
        programInternalCall.setMethodDesc(programCall.getMethodDesc());
        programInternalCall.setArgs(programCall.getArgs());
        frame.vm.getInternalCalls().add(programInternalCall);
        ProgramResult programResult = frame.vm.getProgramExecutor().callProgramExecutor().call(programCall);
        frame.vm.addGasUsed(programResult.getGasUsed());
        frame.vm.getDebugEvents().addAll(programResult.getDebugEvents());
        if (programResult.isSuccess()) {
            frame.vm.getTransfers().addAll(programResult.getTransfers());
            frame.vm.getInternalCalls().addAll(programResult.getInternalCalls());
            frame.vm.getEvents().addAll(programResult.getEvents());
            frame.vm.getInvokeRegisterCmds().addAll(programResult.getInvokeRegisterCmds());
            frame.vm.getOrderedInnerTxs().addAll(programResult.getOrderedInnerTxs());
            int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_15) {
                frame.vm.getInternalCreates().addAll(programResult.getInternalCreates());
            }
            return programResult;
        }
        Iterator<String> descendingIterator = programResult.getStackTraces().descendingIterator();
        while (descendingIterator.hasNext()) {
            frame.vm.getStackTraces().addFirst(descendingIterator.next());
        }
        frame.throwRuntimeException(programResult.getErrorMessage());
        return programResult;
    }

    private static void checkBalance(byte[] address, int assetChainId, int assetId, BigInteger value, Frame frame) {
        if (value == null || value.compareTo(BigInteger.ZERO) <= 0) {
            throw new ErrorException(String.format("transfer amount error, value=%s", value), frame.vm.getGasUsed(), null);
        }
        BigInteger balance = frame.vm.getProgramExecutor().getAccount(address, assetChainId, assetId).getBalance();
        if (balance.compareTo(value) < 0) {
            if (frame.vm.getProgramContext().isEstimateGas()) {
                balance = value;
            } else {
                throw new ErrorException(String.format("contract[%s] not enough balance", NativeAddress.toString(address)), frame.vm.getGasUsed(), null);
            }
        }
    }

    private static Result valid(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        String str = frame.heap.runToString(objectRef);
        boolean valided = NativeAddress.validAddress(frame.vm.getProgramExecutor().getCurrentChainId(), str);
        if (!valided) {
            frame.throwRuntimeException(String.format("address[%s] error", str));
        }
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result isContract(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef addressRef = methodArgs.objectRef;
        String address = frame.heap.runToString(addressRef);
        boolean verify = NativeAddress.isContract(NativeAddress.toBytes(address), frame);
        Result result = NativeMethod.result(methodCode, verify, frame);
        return result;
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return AddressTool.getStringAddressByBytes((byte[])bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("address error", e);
        }
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return AddressTool.getAddress((String)str);
        }
        catch (Exception e) {
            throw new RuntimeException("address error", e);
        }
    }

    public static boolean isContract(byte[] address, Frame frame) {
        byte[] contractAddress = frame.vm.getProgramInvoke().getContractAddress();
        if (Arrays.equals(contractAddress, address)) {
            return true;
        }
        return frame.heap.existContract(address);
    }

    public static boolean validAddress(int chainId, String str) {
        return AddressTool.validAddress((int)chainId, (String)str);
    }

    public static ProgramResult call(String address, String methodName, String methodDesc, String[][] args, BigInteger value, Frame frame) {
        return NativeAddress.call(address, methodName, methodDesc, args, value, frame, null);
    }
}

