/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;
import io.nuls.contract.vm.natives.java.lang.NativeSystem;
import io.nuls.contract.vm.util.CloneUtils;
import java.util.Map;

public class NativeObject {
    public static final String TYPE = "java/lang/Object";
    public static final String getClass = "java/lang/Object.getClass()Ljava/lang/Class;";
    public static final String hashCode = "java/lang/Object.hashCode()I";
    public static final String clone = "java/lang/Object.clone()Ljava/lang/Object;";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Object.getClass()Ljava/lang/Class;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeObject.getClass(methodCode, methodArgs, frame);
            }
            case "java/lang/Object.hashCode()I": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeObject.hashCode(methodCode, methodArgs, frame);
            }
            case "java/lang/Object.clone()Ljava/lang/Object;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeObject.clone(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result getClass(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        ObjectRef classRef = frame.heap.getClassRef(objectRef.getVariableType().getDesc());
        Result result = NativeMethod.result(methodCode, classRef, frame);
        return result;
    }

    private static Result hashCode(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        int hashCode = NativeSystem.identityHashCode(objectRef);
        Result result = NativeMethod.result(methodCode, hashCode, frame);
        return result;
    }

    private static Result clone(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef newRef;
        ObjectRef objectRef = methodArgs.objectRef;
        if (objectRef.isArray()) {
            newRef = frame.heap.newArray(objectRef.getVariableType(), objectRef.getDimensions());
            frame.heap.arraycopy(objectRef, 0, newRef, 0, objectRef.getDimensions()[0]);
        } else {
            Map<String, Object> fields = frame.heap.getFields(objectRef);
            Map<String, Object> newFields = CloneUtils.clone(fields);
            newRef = frame.heap.newObjectRef(null, objectRef.getDesc(), objectRef.getDimensions());
            frame.heap.putFields(newRef, newFields);
        }
        Result result = NativeMethod.result(methodCode, newRef, frame);
        return result;
    }
}

