/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeStrictMath {
    public static final String TYPE = "java/lang/StrictMath";
    public static final String sin = "java/lang/StrictMath.sin(D)D";
    public static final String cos = "java/lang/StrictMath.cos(D)D";
    public static final String tan = "java/lang/StrictMath.tan(D)D";
    public static final String asin = "java/lang/StrictMath.asin(D)D";
    public static final String acos = "java/lang/StrictMath.acos(D)D";
    public static final String atan = "java/lang/StrictMath.atan(D)D";
    public static final String exp = "java/lang/StrictMath.exp(D)D";
    public static final String log = "java/lang/StrictMath.log(D)D";
    public static final String log10 = "java/lang/StrictMath.log10(D)D";
    public static final String sqrt = "java/lang/StrictMath.sqrt(D)D";
    public static final String cbrt = "java/lang/StrictMath.cbrt(D)D";
    public static final String IEEEremainder = "java/lang/StrictMath.IEEEremainder(DD)D";
    public static final String atan2 = "java/lang/StrictMath.atan2(DD)D";
    public static final String pow = "java/lang/StrictMath.pow(DD)D";
    public static final String sinh = "java/lang/StrictMath.sinh(D)D";
    public static final String cosh = "java/lang/StrictMath.cosh(D)D";
    public static final String tanh = "java/lang/StrictMath.tanh(D)D";
    public static final String hypot = "java/lang/StrictMath.hypot(DD)D";
    public static final String expm1 = "java/lang/StrictMath.expm1(D)D";
    public static final String log1p = "java/lang/StrictMath.log1p(D)D";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/StrictMath.sin(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.sin(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.cos(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.cos(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.tan(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.tan(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.asin(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.asin(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.acos(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.acos(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.atan(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.atan(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.exp(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.exp(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.log(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.log(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.log10(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.log10(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.sqrt(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.sqrt(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.cbrt(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.cbrt(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.IEEEremainder(DD)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.IEEEremainder(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.atan2(DD)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.atan2(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.pow(DD)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.pow(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.sinh(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.sinh(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.cosh(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.cosh(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.tanh(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.tanh(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.hypot(DD)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.hypot(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.expm1(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.expm1(methodCode, methodArgs, frame);
            }
            case "java/lang/StrictMath.log1p(D)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeStrictMath.log1p(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result sin(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.sin(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result cos(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.cos(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result tan(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.tan(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result asin(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.asin(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result acos(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.acos(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result atan(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.atan(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result exp(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.exp(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result log(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.log(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result log10(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.log10(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result sqrt(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.sqrt(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result cbrt(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.cbrt(a);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result IEEEremainder(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double f1 = (Double)methodArgs.invokeArgs[0];
        double f2 = (Double)methodArgs.invokeArgs[1];
        double r = StrictMath.IEEEremainder(f1, f2);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result atan2(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double y = (Double)methodArgs.invokeArgs[0];
        double x = (Double)methodArgs.invokeArgs[1];
        double r = StrictMath.atan2(y, x);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result pow(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double a = (Double)methodArgs.invokeArgs[0];
        double b = (Double)methodArgs.invokeArgs[1];
        double r = StrictMath.pow(a, b);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result sinh(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double x = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.sinh(x);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result cosh(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double x = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.cosh(x);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result tanh(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double x = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.tanh(x);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result hypot(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double x = (Double)methodArgs.invokeArgs[0];
        double y = (Double)methodArgs.invokeArgs[1];
        double r = StrictMath.hypot(x, y);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result expm1(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double x = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.expm1(x);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }

    private static Result log1p(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double x = (Double)methodArgs.invokeArgs[0];
        double r = StrictMath.log1p(x);
        Result result = NativeMethod.result(methodCode, r, frame);
        return result;
    }
}

