/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.core.crypto.HexUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class ProgramCreate {
    private long number;
    private byte[] sender;
    private byte[] senderPublicKey;
    private BigInteger value;
    private long gasLimit;
    private long price;
    private byte[] contractAddress;
    private byte[] contractCode;
    private String[][] args;
    private boolean estimateGas;
    private boolean internalCreate;

    public boolean isInternalCreate() {
        return this.internalCreate;
    }

    public void setInternalCreate(boolean internalCreate) {
        this.internalCreate = internalCreate;
    }

    public void args(String ... args) {
        this.setArgs(args);
    }

    public String[][] getArgs() {
        return this.args;
    }

    public void setArgs(String[][] args) {
        this.args = args;
    }

    public void setArgs(String[] args) {
        this.args = ProgramCall.twoDimensionalArray(args);
    }

    public long getNumber() {
        return this.number;
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public byte[] getSender() {
        return this.sender;
    }

    public void setSender(byte[] sender) {
        this.sender = sender;
    }

    public byte[] getSenderPublicKey() {
        return this.senderPublicKey;
    }

    public void setSenderPublicKey(byte[] senderPublicKey) {
        this.senderPublicKey = senderPublicKey;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    public long getPrice() {
        return this.price;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    public byte[] getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(byte[] contractAddress) {
        this.contractAddress = contractAddress;
    }

    public byte[] getContractCode() {
        return this.contractCode;
    }

    public void setContractCode(byte[] contractCode) {
        this.contractCode = contractCode;
    }

    public boolean isEstimateGas() {
        return this.estimateGas;
    }

    public void setEstimateGas(boolean estimateGas) {
        this.estimateGas = estimateGas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramCreate that = (ProgramCreate)o;
        if (this.number != that.number) {
            return false;
        }
        if (this.gasLimit != that.gasLimit) {
            return false;
        }
        if (this.price != that.price) {
            return false;
        }
        if (this.estimateGas != that.estimateGas) {
            return false;
        }
        if (!Arrays.equals(this.sender, that.sender)) {
            return false;
        }
        if (!Arrays.equals(this.senderPublicKey, that.senderPublicKey)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (!Arrays.equals(this.contractAddress, that.contractAddress)) {
            return false;
        }
        if (!Arrays.equals(this.contractCode, that.contractCode)) {
            return false;
        }
        return Arrays.equals((Object[])this.args, (Object[])that.args);
    }

    public int hashCode() {
        int result = (int)(this.number ^ this.number >>> 32);
        result = 31 * result + Arrays.hashCode(this.sender);
        result = 31 * result + Arrays.hashCode(this.senderPublicKey);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.gasLimit ^ this.gasLimit >>> 32);
        result = 31 * result + (int)(this.price ^ this.price >>> 32);
        result = 31 * result + Arrays.hashCode(this.contractAddress);
        result = 31 * result + Arrays.hashCode(this.contractCode);
        result = 31 * result + Arrays.hashCode((Object[])this.args);
        result = 31 * result + (this.estimateGas ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ProgramCreate{number=" + this.number + ", sender=" + (Serializable)(this.sender != null ? (Object)AddressTool.getStringAddressByBytes((byte[])this.sender) : this.sender) + ", senderPublicKey=" + (Serializable)(this.senderPublicKey != null ? (Object)HexUtil.encode((byte[])this.senderPublicKey) : this.senderPublicKey) + ", value=" + this.value + ", gasLimit=" + this.gasLimit + ", price=" + this.price + ", contractAddress=" + (Serializable)(this.contractAddress != null ? (Object)AddressTool.getStringAddressByBytes((byte[])this.contractAddress) : this.contractAddress) + ", contractCode=" + (Serializable)(this.contractCode != null ? String.valueOf(this.contractCode.length) : Integer.valueOf(0)) + ", args=" + ContractUtil.argToString(this.args) + ", estimateGas=" + this.estimateGas + "}";
    }
}

