/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.contract.vm.program.ProgramAccount;
import io.nuls.contract.vm.program.ProgramInternalCall;
import io.nuls.contract.vm.program.ProgramInternalCreate;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramTransfer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ProgramResult {
    private long gasUsed;
    private String result;
    private boolean revert;
    private boolean error;
    private String errorMessage;
    private String stackTrace;
    private String nonce;
    private Map<String, ProgramAccount> accounts;
    private List<ProgramTransfer> transfers = new ArrayList<ProgramTransfer>();
    private List<ProgramInternalCall> internalCalls = new ArrayList<ProgramInternalCall>();
    private List<String> events = new ArrayList<String>();
    private List<String> debugEvents = new ArrayList<String>();
    private List<ProgramInvokeRegisterCmd> invokeRegisterCmds = new ArrayList<ProgramInvokeRegisterCmd>();
    private List<Object> orderedInnerTxs = new ArrayList<Object>();
    private LinkedList<String> stackTraces = new LinkedList();
    private List<ProgramInternalCreate> internalCreates = new ArrayList<ProgramInternalCreate>();

    public List<ProgramInternalCreate> getInternalCreates() {
        return this.internalCreates;
    }

    public void setInternalCreates(List<ProgramInternalCreate> internalCreates) {
        this.internalCreates = internalCreates;
    }

    public LinkedList<String> getStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(LinkedList<String> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public ProgramResult revert(String errorMessage) {
        this.revert = true;
        this.errorMessage = errorMessage;
        return this;
    }

    public ProgramResult error(String errorMessage) {
        this.error = true;
        this.errorMessage = errorMessage;
        return this;
    }

    public static ProgramResult getFailed(String errorMessage) {
        ProgramResult result = new ProgramResult();
        return result.error(errorMessage);
    }

    public static ProgramResult getFailed() {
        ProgramResult result = new ProgramResult();
        return result.error(null);
    }

    public void view() {
        this.transfers = new ArrayList<ProgramTransfer>();
        this.events = new ArrayList<String>();
    }

    public boolean isSuccess() {
        return !this.error && !this.revert;
    }

    public long getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(long gasUsed) {
        this.gasUsed = gasUsed;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean isRevert() {
        return this.revert;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Map<String, ProgramAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Map<String, ProgramAccount> accounts) {
        this.accounts = accounts;
    }

    public List<ProgramTransfer> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(List<ProgramTransfer> transfers) {
        this.transfers = transfers;
    }

    public List<ProgramInternalCall> getInternalCalls() {
        return this.internalCalls;
    }

    public void setInternalCalls(List<ProgramInternalCall> internalCalls) {
        this.internalCalls = internalCalls;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public List<String> getDebugEvents() {
        return this.debugEvents;
    }

    public void setDebugEvents(List<String> debugEvents) {
        this.debugEvents = debugEvents;
    }

    public List<ProgramInvokeRegisterCmd> getInvokeRegisterCmds() {
        return this.invokeRegisterCmds;
    }

    public void setInvokeRegisterCmds(List<ProgramInvokeRegisterCmd> invokeRegisterCmds) {
        this.invokeRegisterCmds = invokeRegisterCmds;
    }

    public List<Object> getOrderedInnerTxs() {
        return this.orderedInnerTxs;
    }

    public void setOrderedInnerTxs(List<Object> orderedInnerTxs) {
        this.orderedInnerTxs = orderedInnerTxs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProgramResult)) {
            return false;
        }
        ProgramResult that = (ProgramResult)o;
        return new EqualsBuilder().append(this.getGasUsed(), that.getGasUsed()).append(this.isRevert(), that.isRevert()).append(this.isError(), that.isError()).append((Object)this.getResult(), (Object)that.getResult()).append((Object)this.getErrorMessage(), (Object)that.getErrorMessage()).append((Object)this.getStackTrace(), (Object)that.getStackTrace()).append((Object)this.getNonce(), (Object)that.getNonce()).append(this.getTransfers(), that.getTransfers()).append(this.getInternalCalls(), that.getInternalCalls()).append(this.getEvents(), that.getEvents()).append(this.getInvokeRegisterCmds(), that.getInvokeRegisterCmds()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.getGasUsed()).append((Object)this.getResult()).append(this.isRevert()).append(this.isError()).append((Object)this.getErrorMessage()).append((Object)this.getStackTrace()).append((Object)this.getNonce()).append(this.getTransfers()).append(this.getInternalCalls()).append(this.getEvents()).append(this.getInvokeRegisterCmds()).toHashCode();
    }

    public String toString() {
        return "ProgramResult{gasUsed=" + this.gasUsed + ", result='" + this.result + "', revert=" + this.revert + ", error=" + this.error + ", errorMessage='" + this.errorMessage + "', stackTrace='" + this.stackTrace + "', nonce=" + this.nonce + ", transfers=" + this.transfers + ", internalCalls=" + this.internalCalls + ", events=" + this.events + ", debugEvents=" + this.debugEvents + ", invokeRegisterCmds=" + this.invokeRegisterCmds + "}";
    }
}

