/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program.impl;

import com.google.common.base.Joiner;
import io.nuls.contract.vm.OpCode;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.ClassCodeLoader;
import io.nuls.contract.vm.code.FieldCode;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.program.impl.ProgramConstants;
import io.nuls.contract.vm.program.impl.ProgramExecutorImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramChecker {
    private static final Logger log = LoggerFactory.getLogger(ProgramExecutorImpl.class);
    public static Set<String> notSupportMethods = new TreeSet<String>();

    public static void check(Map<String, ClassCode> classCodes) {
        ProgramChecker.checkJdkVersion(classCodes);
        ProgramChecker.checkContractNum(classCodes);
        ProgramChecker.checkClass(classCodes);
        ProgramChecker.checkContractMethodArgs(classCodes);
        ProgramChecker.checkMethod(classCodes);
        ProgramChecker.checkOpCode(classCodes);
    }

    public static void checkJdkVersion(Map<String, ClassCode> classCodes) {
        for (ClassCode classCode : classCodes.values()) {
            if (classCode.isV1_6 || classCode.isV1_8) continue;
            throw new RuntimeException("class version must be 1.6 or 1.8");
        }
    }

    public static void checkContractNum(Map<String, ClassCode> classCodes) {
        List contractClassCodes = classCodes.values().stream().filter(classCode -> classCode.interfaces.contains("io/nuls/contract/sdk/Contract")).collect(Collectors.toList());
        int contractCount = contractClassCodes.size();
        if (contractCount != 1) {
            throw new RuntimeException(String.format("find %s contracts", contractCount));
        }
    }

    public static void checkContractMethodArgs(Map<String, ClassCode> classCodes) {
        List<MethodCode> list = ProgramExecutorImpl.getProgramMethodCodes(classCodes);
        for (MethodCode methodCode : list) {
            List<VariableType> variableTypes = methodCode.argsVariableType;
            for (VariableType variableType : variableTypes) {
                if (variableType.isPrimitive()) continue;
                if (variableType.isArray()) {
                    if (variableType.getDimensions() > 1) {
                        if (variableType.getDimensions() == 2 && "_payable".equals(methodCode.name) && "([[Ljava/lang/String;)V".equals(methodCode.desc)) continue;
                        throw new RuntimeException(String.format("only one-dimensional array can be used in method %s.%s", methodCode.className, methodCode.name));
                    }
                    if (variableType.isPrimitiveType() || variableType.getComponentType().isStringType() || variableType.getComponentType().isWrapperType()) continue;
                    throw new RuntimeException(String.format("only primitive type array and string array can be used in method %s.%s", methodCode.className, methodCode.name));
                }
                if (ProgramChecker.hasConstructor(variableType, classCodes)) continue;
                throw new RuntimeException(String.format("%s can't be used in method %s.%s", variableType.getType(), methodCode.className, methodCode.name));
            }
        }
    }

    public static void checkClass(Map<String, ClassCode> classCodes) {
        Set classCodeNames;
        Set<String> allClass = ProgramChecker.allClass(classCodes);
        Collection classes = CollectionUtils.removeAll(allClass, classCodeNames = classCodes.values().stream().map(classCode -> classCode.name).collect(Collectors.toSet()));
        Collection classes1 = CollectionUtils.removeAll((Collection)classes, Arrays.asList(ProgramConstants.SDK_CLASS_NAMES));
        Collection classes2 = CollectionUtils.removeAll((Collection)classes1, Arrays.asList(ProgramConstants.CONTRACT_USED_CLASS_NAMES));
        Collection classes3 = CollectionUtils.removeAll((Collection)classes2, Arrays.asList(ProgramConstants.CONTRACT_LAZY_USED_CLASS_NAMES));
        if (classes3.size() > 0) {
            throw new RuntimeException(String.format("can't use classes: %s", Joiner.on((String)", ").join((Iterable)classes3)));
        }
    }

    public static void checkMethod(Map<String, ClassCode> classCodes) {
        HashMap<String, Object> methodCodes = new HashMap<String, Object>(1024);
        for (ClassCode classCode : classCodes.values()) {
            for (MethodCode methodCode : classCode.methods) {
                Object o = methodCodes.get(methodCode.fullName);
                if (o == null) {
                    o = ProgramChecker.isSupportMethod(methodCode, methodCodes, classCodes);
                    methodCodes.put(methodCode.fullName, o);
                }
                if (Boolean.TRUE.equals(o)) continue;
                if (o != null) {
                    MethodInsnNode methodInsnNode = (MethodInsnNode)o;
                    throw new RuntimeException(String.format("can't use method: %s.%s%s", methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc));
                }
                throw new RuntimeException(String.format("can't use method: %s.%s%s", methodCode.className, methodCode.name, methodCode.desc));
            }
        }
    }

    public static void checkOpCode(Map<String, ClassCode> classCodes) {
        for (ClassCode classCode : classCodes.values()) {
            for (MethodCode methodCode : classCode.methods) {
                ProgramChecker.checkOpCode(methodCode);
            }
        }
    }

    public static void checkOpCode(MethodCode methodCode) {
        for (AbstractInsnNode abstractInsnNode : methodCode.instructions) {
            if (abstractInsnNode == null || abstractInsnNode.getOpcode() <= 0) continue;
            OpCode opCode = OpCode.valueOf(abstractInsnNode.getOpcode());
            boolean nonsupport = false;
            if (opCode == null) {
                nonsupport = true;
            } else {
                switch (opCode) {
                    case JSR: 
                    case RET: 
                    case INVOKEDYNAMIC: 
                    case MONITORENTER: 
                    case MONITOREXIT: {
                        nonsupport = true;
                        break;
                    }
                }
            }
            if (!nonsupport) continue;
            int line = ProgramChecker.getLine(abstractInsnNode);
            throw new RuntimeException(String.format("nonsupport opcode: class(%s), line(%d)", methodCode.className, line));
        }
    }

    public static Set<String> allClass(Map<String, ClassCode> classCodes) {
        HashSet<String> set = new HashSet<String>(100);
        for (ClassCode classCode : classCodes.values()) {
            set.add(classCode.name);
            set.add(classCode.superName);
            set.addAll(classCode.interfaces);
            for (InnerClassNode innerClassNode : classCode.innerClasses) {
                set.add(innerClassNode.name);
            }
            for (FieldCode fieldCode : classCode.fields.values()) {
                set.add(fieldCode.desc);
            }
            for (MethodCode methodCode : classCode.methods) {
                set.addAll(ProgramChecker.allClass(methodCode));
            }
        }
        HashSet<String> classes = new HashSet<String>(set.size() * 5);
        for (String s : set) {
            if (s == null) continue;
            if (s.contains("$")) {
                // empty if block
            }
            if (s.contains("(")) {
                List<VariableType> list = VariableType.parseAll(s);
                for (VariableType variableType : list) {
                    if (variableType.isPrimitiveType() || !variableType.isNotVoid()) continue;
                    classes.add(variableType.getType());
                }
                continue;
            }
            VariableType variableType = VariableType.valueOf(s);
            if (variableType.isPrimitiveType() || !variableType.isNotVoid()) continue;
            classes.add(variableType.getType());
        }
        return classes;
    }

    public static Set<String> allClass(MethodCode methodCode) {
        HashSet<String> set = new HashSet<String>();
        set.add(methodCode.returnVariableType.getType());
        for (VariableType variableType : methodCode.argsVariableType) {
            set.add(variableType.getType());
        }
        for (AbstractInsnNode abstractInsnNode : methodCode.instructions) {
            MultiANewArrayInsnNode insnNode;
            if (abstractInsnNode instanceof MultiANewArrayInsnNode) {
                insnNode = (MultiANewArrayInsnNode)abstractInsnNode;
                set.add(insnNode.desc);
                continue;
            }
            if (abstractInsnNode instanceof MethodInsnNode) {
                insnNode = (MethodInsnNode)abstractInsnNode;
                set.add(insnNode.owner);
                set.add(insnNode.desc);
                continue;
            }
            if (abstractInsnNode instanceof TypeInsnNode) {
                insnNode = (TypeInsnNode)abstractInsnNode;
                set.add(insnNode.desc);
                continue;
            }
            if (!(abstractInsnNode instanceof FieldInsnNode)) continue;
            insnNode = (FieldInsnNode)abstractInsnNode;
            set.add(insnNode.owner);
            set.add(insnNode.desc);
        }
        return set;
    }

    public static Object isSupportMethod(MethodCode methodCode, Map<String, Object> methodCodes, Map<String, ClassCode> classCodeMap) {
        if (!methodCodes.containsKey(methodCode.fullName)) {
            methodCodes.put(methodCode.fullName, null);
            for (AbstractInsnNode abstractInsnNode : methodCode.instructions) {
                if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                VariableType variableType = VariableType.valueOf(methodInsnNode.owner);
                if (variableType.isPrimitiveType()) continue;
                ClassCode classCode = ProgramChecker.getClassCode(variableType.getType(), classCodeMap);
                if (classCode == null) {
                    log.warn("can't find class " + methodInsnNode.owner);
                    return methodInsnNode;
                }
                MethodCode methodCode1 = ProgramChecker.getMethodCode(classCode, methodInsnNode.name, methodInsnNode.desc, classCodeMap);
                if (methodCode1 == null) {
                    log.warn(String.format("can't find method %s.%s%s", methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc));
                    return methodInsnNode;
                }
                Object o = ProgramChecker.isSupportMethod(methodCode1, methodCodes, classCodeMap);
                if (Boolean.TRUE.equals(o)) continue;
                log.warn(String.format("not support method %s.%s%s", methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc));
                return methodInsnNode;
            }
        }
        return Boolean.TRUE;
    }

    public static MethodCode getMethodCode(ClassCode classCode, String methodName, String methodDesc, Map<String, ClassCode> classCodeMap) {
        MethodCode methodCode;
        block2: {
            String interfaceName;
            ClassCode interfaceClassCode;
            ClassCode superClassCode;
            methodCode = classCode.getMethodCode(methodName, methodDesc);
            if (methodCode == null && classCode.superName != null && (superClassCode = ProgramChecker.getClassCode(classCode.superName, classCodeMap)) != null) {
                methodCode = ProgramChecker.getMethodCode(superClassCode, methodName, methodDesc, classCodeMap);
            }
            if (methodCode != null) break block2;
            Iterator<String> iterator = classCode.interfaces.iterator();
            while (iterator.hasNext() && (methodCode = ProgramChecker.getMethodCode(interfaceClassCode = ProgramChecker.getClassCode(interfaceName = iterator.next(), classCodeMap), methodName, methodDesc, classCodeMap)) == null) {
            }
        }
        return methodCode;
    }

    public static int getLine(AbstractInsnNode abstractInsnNode) {
        while (!(abstractInsnNode instanceof LineNumberNode)) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        return ((LineNumberNode)abstractInsnNode).line;
    }

    public static boolean hasConstructor(VariableType variableType, Map<String, ClassCode> classCodeMap) {
        MethodCode methodCode;
        ClassCode classCode = ProgramChecker.getClassCode(variableType.getType(), classCodeMap);
        return classCode != null && (methodCode = classCode.getMethodCode("<init>", "(Ljava/lang/String;)V")) != null && methodCode.isPublic;
    }

    private static ClassCode getClassCode(String className, Map<String, ClassCode> classCodeMap) {
        ClassCode classCode = classCodeMap.get(className);
        if (classCode == null) {
            classCode = ClassCodeLoader.getFromResource(className);
        }
        return classCode;
    }
}

