/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class Circulation
extends BaseNulsData {
    private int assetId;
    private BigInteger availableAmount;
    private BigInteger freeze;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.assetId);
        stream.writeBigInteger(this.availableAmount);
        stream.writeBigInteger(this.freeze);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.assetId = byteBuffer.readUint16();
        this.availableAmount = byteBuffer.readBigInteger();
        this.freeze = byteBuffer.readBigInteger();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        return size += SerializeUtils.sizeOfBigInteger() * 2;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assertId) {
        this.assetId = assertId;
    }

    public BigInteger getAvailableAmount() {
        return this.availableAmount;
    }

    public void setAvailableAmount(BigInteger availableAmount) {
        this.availableAmount = availableAmount;
    }

    public BigInteger getFreeze() {
        return this.freeze;
    }

    public void setFreeze(BigInteger freeze) {
        this.freeze = freeze;
    }
}

