/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.utils;

import java.util.HashMap;
import java.util.Map;

public class HashSetTimeDuplicateProcessor {
    private static final long allowMs = 60000L;
    private final int maxSize;
    private final int percent90;
    private final long timeoutMs;
    private Map<String, Long> map1 = new HashMap<String, Long>();
    private Map<String, Long> map2 = new HashMap<String, Long>();

    public HashSetTimeDuplicateProcessor(int maxSize, long ms) {
        this.maxSize = maxSize;
        this.percent90 = maxSize * 9 / 10;
        this.timeoutMs = ms;
    }

    public synchronized boolean insertAndCheck(String hash) {
        boolean result = this.map1.containsKey(hash);
        if (!result) {
            this.map1.put(hash, System.currentTimeMillis());
            return true;
        }
        Long start = this.map1.get(hash);
        long sub = System.currentTimeMillis() - start;
        long timeVal = System.currentTimeMillis();
        if (sub >= this.timeoutMs || sub < 60000L) {
            result = true;
        } else {
            timeVal = start;
            result = false;
        }
        this.map1.put(hash, timeVal);
        int size = this.map1.size();
        if (size >= this.maxSize) {
            this.map2.put(hash, timeVal);
            this.map1.clear();
            this.map1.putAll(this.map2);
            this.map2.clear();
        } else if (size >= this.percent90) {
            this.map2.put(hash, timeVal);
        }
        return result;
    }

    public boolean contains(String hash) {
        return this.map1.containsKey(hash);
    }

    public void remove(String hash) {
        this.map1.remove(hash);
        this.map2.remove(hash);
    }

    public static void main(String[] args) {
        HashSetTimeDuplicateProcessor processor = new HashSetTimeDuplicateProcessor(1000, 100000L);
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("1"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("2"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("3"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("1"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("2"));
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HashSetTimeDuplicateProcessor.assertFlaseTest(processor.insertAndCheck("1"));
        HashSetTimeDuplicateProcessor.assertFlaseTest(processor.insertAndCheck("2"));
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("1"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("2"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("3"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("1"));
        HashSetTimeDuplicateProcessor.assertTrueTest(processor.insertAndCheck("2"));
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HashSetTimeDuplicateProcessor.assertFlaseTest(processor.insertAndCheck("1"));
        HashSetTimeDuplicateProcessor.assertFlaseTest(processor.insertAndCheck("2"));
        System.out.println("Success!!");
    }

    private static void assertTrueTest(boolean b) {
        if (!b) {
            throw new RuntimeException("\u9884\u671f\u4e3atrue\uff0c\u5b9e\u9645\u5f97\u5230false");
        }
    }

    private static void assertFlaseTest(boolean b) {
        if (b) {
            throw new RuntimeException("\u9884\u671f\u4e3afalse\uff0c\u5b9e\u9645\u5f97\u5230true");
        }
    }
}

