/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class VerifierChangeSendFailPO
extends BaseNulsData {
    private Set<Integer> chains = new HashSet<Integer>();

    public VerifierChangeSendFailPO() {
    }

    public VerifierChangeSendFailPO(Set<Integer> chains) {
        this.chains = chains;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        if (this.chains != null && this.chains.size() > 0) {
            for (Integer chainId : this.chains) {
                stream.writeUint16(chainId.intValue());
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        HashSet<Integer> chains = new HashSet<Integer>();
        while (!byteBuffer.isFinished()) {
            int course = byteBuffer.getCursor();
            byteBuffer.setCursor(course);
            chains.add(byteBuffer.readUint16());
        }
        this.chains = chains;
    }

    public int size() {
        int size = 0;
        if (this.chains != null && this.chains.size() > 0) {
            size += SerializeUtils.sizeOfUint16() * this.chains.size();
        }
        return size;
    }

    public Set<Integer> getChains() {
        return this.chains;
    }

    public void setChains(Set<Integer> chains) {
        this.chains = chains;
    }
}

