/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.crosschain.model.bo.Chain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsensusCall {
    public static Map getPackerInfo(Chain chain) {
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(4);
            params.put("chainId", chain.getChainId());
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_getPackerInfo", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packing state failed to send!");
            }
            return (HashMap)((HashMap)cmdResp.getResponseData()).get("cs_getPackerInfo");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }

    public static List<String> getWorkAgentList(Chain chain) {
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(4);
            params.put("chainId", chain.getChainId());
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_getAgentAddressList", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packing state failed to send!");
            }
            return (List)((HashMap)((HashMap)cmdResp.getResponseData()).get("cs_getAgentAddressList")).get("packAddress");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }

    public static Map getSeedNodeList(Chain chain) {
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(4);
            params.put("chainId", chain.getChainId());
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_getSeedNodeInfo", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packing state failed to send!");
            }
            return (HashMap)((HashMap)cmdResp.getResponseData()).get("cs_getSeedNodeInfo");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }

    public static List<String> getRoundMemberList(Chain chain, BlockHeader blockHeader) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chain.getChainId());
            params.put("extend", RPCUtil.encode((byte[])blockHeader.getExtend()));
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_getRoundMemberList", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packing state failed to send!");
            }
            return (List)((HashMap)((HashMap)cmdResp.getResponseData()).get("cs_getRoundMemberList")).get("packAddressList");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }

    public static Map<String, List<String>> getAgentChangeInfo(Chain chain, byte[] lastRound, byte[] currentRound) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chain.getChainId());
            if (lastRound == null) {
                params.put("lastRound", null);
            } else {
                params.put("lastRound", RPCUtil.encode((byte[])lastRound));
            }
            params.put("currentRound", RPCUtil.encode((byte[])currentRound));
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_getAgentChangeInfo", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packing state failed to send!");
            }
            return (HashMap)((HashMap)cmdResp.getResponseData()).get("cs_getAgentChangeInfo");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }
}

