/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.cmd;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.transaction.TransferService;
import io.nuls.base.api.provider.transaction.facade.GetConfirmedTxByHashReq;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.crosschain.base.message.CrossTxRehandleMessage;
import io.nuls.crosschain.message.CrossTxRehandleMsgHandler;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.io.IOException;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CC)
public class CrossChainTxCmd
extends BaseCmd {
    @Autowired
    private ConvertCtxService convertCtxService;
    @Autowired
    private CtxStatusService ctxStatusService;
    @Autowired
    NulsCoresConfig config;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    CrossTxRehandleMsgHandler crossTxRehandleMsgHandler;
    TransferService transferService = (TransferService)ServiceManager.get(TransferService.class);

    @CmdAnnotation(cmd="getCrossChainTxInfoForConverterTable", version=1.0, description="Through transactionshashQuery transaction details in the cross chain module")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="transactionhash")})
    @ResponseData(description="")
    public Response getCrossChainTxInfoForConverterTable(Map<String, Object> params) throws IOException {
        Transaction transaction = this.convertCtxService.get(new NulsHash(HexUtil.decode((String)((String)params.get("txHash")))), this.config.getChainId());
        return this.success(HexUtil.encode((byte[])transaction.serialize()));
    }

    @CmdAnnotation(cmd="getCrossChainTxInfoForCtxStatusPO", version=1.0, description="Through transactionshashQuery transaction details in the cross chain module")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="transactionhash")})
    @ResponseData(description="")
    public Response getCrossChainTxInfoForCtxStatusPO(Map<String, Object> params) throws IOException {
        CtxStatusPO transaction = this.ctxStatusService.get(new NulsHash(HexUtil.decode((String)((String)params.get("txHash")))), this.config.getChainId());
        if (transaction == null || transaction.getTx() == null) {
            return this.failed("not found tx");
        }
        return this.success(HexUtil.encode((byte[])transaction.getTx().serialize()));
    }

    @CmdAnnotation(cmd="ctxRehandle", version=1.0, description="Through transactionshashQuery transaction details in the cross chain module")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="ctxHash", parameterType="String", parameterDes="transactionhash"), @Parameter(parameterName="blockHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="Current block height")})
    @ResponseData(description="")
    public Response crossTxRehandle(Map<String, Object> params) throws IOException {
        String ctxHash = (String)params.get("ctxHash");
        Result tx = this.transferService.getConfirmedTxByHash(new GetConfirmedTxByHashReq(ctxHash));
        if (tx.isFailed()) {
            return this.failed(tx.getMessage());
        }
        Transaction transaction = (Transaction)tx.getData();
        if (transaction.getType() != 10 && transaction.getType() != 26) {
            return this.failed("not a cross chain tx");
        }
        long height = Long.parseLong(params.get("blockHeight").toString());
        int chainId = (Integer)params.get("chainId");
        CrossTxRehandleMessage crossTxRehandleMessage = new CrossTxRehandleMessage();
        crossTxRehandleMessage.setCtxHash(transaction.getHash());
        crossTxRehandleMessage.setBlockHeight(height);
        this.crossTxRehandleMsgHandler.process(chainId, crossTxRehandleMessage);
        boolean res = NetWorkCall.broadcast(chainId, crossTxRehandleMessage, "ctxRehandle", false);
        if (res) {
            return this.success(Map.of("msg", "broadcast success"));
        }
        return this.success(Map.of("msg", "broadcast fail"));
    }
}

