/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.crosschain.base.constant.CrossChainErrorCode;
import io.nuls.crosschain.base.message.CirculationMessage;
import io.nuls.crosschain.base.service.ResetLocalVerifierService;
import io.nuls.crosschain.servive.MainNetService;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CC)
public class MainNetCmd
extends BaseCmd {
    @Autowired
    private MainNetService service;
    @Autowired
    RegisteredCrossChainService registeredCrossChainService;
    @Autowired
    ResetLocalVerifierService resetLocalVerifierService;

    @CmdAnnotation(cmd="registerCrossChain", version=1.0, description="Chain registration cross chain/register Cross Chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="chainName", parameterType="String", parameterDes="Chain Name"), @Parameter(parameterName="minAvailableNodeNum", requestType=@TypeDescriptor(value=int.class), parameterDes="Minimum number of links"), @Parameter(parameterName="assetInfoList", parameterType="List<AssetInfo>", parameterDes="Asset List"), @Parameter(parameterName="registerTime", requestType=@TypeDescriptor(value=long.class), parameterDes="Chain registration time")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Processing results")}))
    public Response registerCrossChain(Map<String, Object> params) {
        Result result = this.service.registerCrossChain(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="registerAsset", version=1.0, description="Chain registration of new assets/register Cross Chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetID"), @Parameter(parameterName="symbol", parameterType="String", parameterDes="Asset symbols"), @Parameter(parameterName="assetName", parameterType="String", parameterDes="Asset Name"), @Parameter(parameterName="usable", requestType=@TypeDescriptor(value=boolean.class), parameterDes="Is it available"), @Parameter(parameterName="decimalPlaces", requestType=@TypeDescriptor(value=int.class), parameterDes="accuracy"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="Chain registration time")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Processing results")}))
    public Response registerAsset(Map<String, Object> params) {
        Result result = this.service.registerAssert(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="cancelCrossChain", version=1.0, description="Designated chain assets exit cross chain/Specified Chain Assets Exit Cross Chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetID"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="Chain registration time")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Processing results")}))
    public Response cancelCrossChain(Map<String, Object> params) {
        Result result = this.service.cancelCrossChain(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="crossChainRegisterChange", version=1.0, description="Changes in cross chain assets of Friendly Chain/Registered Cross Chain change")
    @Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")
    @ResponseData(description="No specific return value, successful without errors")
    public Response crossChainRegisterChange(Map<String, Object> params) {
        Result result = this.service.crossChainRegisterChange(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="recvCirculat", version=1.0, description="Receive asset information sent by other chain nodes/Receiving asset information sent by other link nodes")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response recvCirculat(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        CirculationMessage message = new CirculationMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.receiveCirculation(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="getFriendChainCirculate", version=1.0, description="Obtaining Friendly Chain Asset Information/Access to Friendship Chain Asset Information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="assetIds", parameterType="String", parameterDes="assetIDMultiple assetsIDSeparate with commas")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response getFriendChainCirculate(Map<String, Object> params) {
        Result result = this.service.getFriendChainCirculation(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="cc_tokenOutCrossChain", version=1.0, description="Smart contract assets cross chain/Smart contract assets cross chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetID"), @Parameter(parameterName="from", parameterDes="Outgoing address"), @Parameter(parameterName="to", parameterDes="Address transfer"), @Parameter(parameterName="value", parameterDes="money"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="contractSender", parameterDes="Contract caller address"), @Parameter(parameterName="contractBalance", parameterDes="Current balance of contract address"), @Parameter(parameterName="contractNonce", parameterDes="The current contract addressnoncevalue"), @Parameter(parameterName="blockTime", requestType=@TypeDescriptor(value=long.class), parameterDes="The current packaged block time")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=Boolean.class, description="transactionhash"), @Key(name="tx", valueType=Boolean.class, description="Transaction String")}))
    public Response tokenOutCrossChain(Map<String, Object> params) {
        Result result = this.service.tokenOutCrossChain(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        Map data = (Map)result.getData();
        String txHash = (String)data.get("txHash");
        String txHex = (String)data.get("tx");
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        resultMap.put("value", List.of(txHash, txHex));
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="cc_getRegisterChainInfo", version=1.0, description="Obtain all registered chain information")
    public Response getRegisterChainInfo(Map<String, Object> params) {
        return this.success((Object)this.registeredCrossChainService.get());
    }

    @CmdAnnotation(cmd="createResetLocalVerifierTx", version=1.0, description="Create a reset chain validator transaction transaction")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Call address"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Call address password"), @Parameter(parameterName="remark", parameterType="String", parameterDes="Remarks", canNull=true)})
    @ResponseData(name="Return value", description="transactionHASH", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="transactionHASH")}))
    public Response createResetLocalVerifierTx(Map<String, Object> params) {
        String password;
        String address;
        int chainId = Integer.parseInt(params.get("chainId").toString());
        Result res = this.resetLocalVerifierService.createResetLocalVerifierTx(chainId, address = (String)params.get("address"), password = (String)params.get("password"));
        if (res.isSuccess()) {
            return this.success(res);
        }
        return this.failed(res.getErrorCode());
    }
}

