/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.base.model.bo.txdata.VerifierChangeData;
import io.nuls.crosschain.base.service.VerifierChangeTxService;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.manager.LocalVerifierManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class VerifierChangeTxServiceImpl
implements VerifierChangeTxService {
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private ConvertHashService convertHashService;
    @Autowired
    private RegisteredCrossChainService registeredCrossChainService;

    @Override
    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String errorCode = null;
        for (Transaction verifierChangeTx : txs) {
            try {
                ArrayList<String> verifierList;
                boolean dataValid;
                VerifierChangeData verifierChangeData = new VerifierChangeData();
                verifierChangeData.parse(verifierChangeTx.getTxData(), 0);
                List<String> registerList = verifierChangeData.getRegisterAgentList();
                List<String> cancelList = verifierChangeData.getCancelAgentList();
                int verifierChainId = verifierChangeData.getChainId();
                boolean haveCancelVerifier = cancelList != null && !cancelList.isEmpty();
                boolean bl = dataValid = haveCancelVerifier || registerList != null && !registerList.isEmpty();
                if (!dataValid || verifierChainId <= 0) {
                    chain.getLogger().error("Verifier change information is invalid,chainId:{}", new Object[]{verifierChainId});
                }
                if (verifierChainId == chainId) {
                    verifierList = new ArrayList<String>(chain.getVerifierList());
                } else {
                    ChainInfo chainInfo = this.chainManager.getChainInfo(verifierChainId);
                    if (chainInfo == null) {
                        chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
                        throw new NulsException(NulsCrossChainErrorCode.CHAIN_UNREGISTERED);
                    }
                    verifierList = new ArrayList<String>(chainInfo.getVerifierList());
                }
                if (haveCancelVerifier) {
                    int maxCancelCount = verifierList.size() * 30 / 100;
                    if (cancelList.size() > maxCancelCount) {
                        chain.getLogger().error("Abnormal change of transaction data of verifier: the verifier who exits is more than 30%,cancelCount:{},maxCancelCount:{},totalCount:{}", new Object[]{cancelList.size(), maxCancelCount, verifierList.size()});
                        throw new NulsException(NulsCrossChainErrorCode.TO_MANY_VERIFIER_EXIT);
                    }
                    verifierList.removeAll(cancelList);
                }
                int minPassCount = CommonUtil.getByzantineCount(chain, verifierList.size());
                if (verifierList.isEmpty()) {
                    chain.getLogger().error("The chain has not registered a verifier yet,chainId:{}", new Object[]{verifierChainId});
                    throw new NulsException(NulsCrossChainErrorCode.CHAIN_UNREGISTERED_VERIFIER);
                }
                if (!SignatureUtil.validateCtxSignture((Transaction)verifierChangeTx)) {
                    chain.getLogger().error("Main network protocol cross chain transaction signature verification failed\uff01");
                    throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
                }
                if (TxUtil.signByzantineVerify(chain, verifierChangeTx, verifierList, minPassCount, verifierChainId)) continue;
                chain.getLogger().error("Signature Byzantine verification failed\uff01");
                throw new NulsException(NulsCrossChainErrorCode.CTX_SIGN_BYZANTINE_FAIL);
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
                invalidTxList.add(verifierChangeTx);
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    @Override
    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        int syncStatus = BlockCall.getBlockStatus(chain);
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        for (Transaction verifierChangeTx : txs) {
            try {
                NulsHash ctxHash = verifierChangeTx.getHash();
                if (!this.convertHashService.save(ctxHash, ctxHash, chainId)) {
                    this.rollback(chainId, commitSuccessList, blockHeader);
                    return false;
                }
                VerifierChangeData verifierChangeData = new VerifierChangeData();
                verifierChangeData.parse(verifierChangeTx.getTxData(), 0);
                List<String> registerList = verifierChangeData.getRegisterAgentList();
                List<String> cancelList = verifierChangeData.getCancelAgentList();
                int verifierChainId = verifierChangeData.getChainId();
                if (verifierChainId == chainId) {
                    if (chain.getVerifierChangeTx() != null && !ctxHash.equals((Object)chain.getVerifierChangeTx().getHash())) {
                        chain.getLogger().warn("Local processing verifier change transaction changed,commitHash:{},cacheHash:{}", new Object[]{ctxHash.toHex(), chain.getVerifierChangeTx().getHash().toHex()});
                        continue;
                    }
                    VerifierChangeData txData = new VerifierChangeData();
                    try {
                        txData.parse(verifierChangeTx.getTxData(), 0);
                    }
                    catch (NulsException e) {
                        chain.getLogger().error(e);
                        continue;
                    }
                    if (!LocalVerifierManager.localVerifierChangeCommit(chain, verifierChangeTx, txData.getCancelAgentList(), txData.getRegisterAgentList(), blockHeader.getHeight(), ctxHash, syncStatus)) {
                        chain.getLogger().error("Verifier change failed");
                        continue;
                    }
                    commitSuccessList.add(verifierChangeTx);
                    continue;
                }
                ChainInfo chainInfo = this.chainManager.getChainInfo(verifierChainId);
                chain.getLogger().info("chain{}The current list of validators is\uff1a{}", new Object[]{verifierChainId, chainInfo.getVerifierList().toString()});
                if (registerList != null && !registerList.isEmpty()) {
                    chainInfo.getVerifierList().addAll(registerList);
                    chain.getLogger().info("Add validation list as\uff1a{}", new Object[]{registerList.toString()});
                }
                if (cancelList != null && !cancelList.isEmpty()) {
                    chainInfo.getVerifierList().removeAll(cancelList);
                    chain.getLogger().info("The list of verifiers to be logged out is\uff1a{}", new Object[]{cancelList.toString()});
                }
                chain.getLogger().info("chain{}The updated validation list is{}", new Object[]{verifierChainId, chainInfo.getVerifierList().toString()});
                RegisteredChainMessage registeredChainMessage = new RegisteredChainMessage();
                registeredChainMessage.setChainInfoList(this.chainManager.getRegisteredCrossChainList());
                if (!this.registeredCrossChainService.save(registeredChainMessage)) {
                    this.rollback(chainId, commitSuccessList, blockHeader);
                    return false;
                }
                commitSuccessList.add(verifierChangeTx);
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                this.rollback(chainId, commitSuccessList, blockHeader);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        for (Transaction verifierChangeTx : txs) {
            try {
                NulsHash ctxHash = verifierChangeTx.getHash();
                if (!this.convertHashService.delete(ctxHash, chainId)) {
                    return false;
                }
                VerifierChangeData verifierChangeData = new VerifierChangeData();
                verifierChangeData.parse(verifierChangeTx.getTxData(), 0);
                List<String> registerList = verifierChangeData.getRegisterAgentList();
                List<String> cancelList = verifierChangeData.getCancelAgentList();
                int verifierChainId = verifierChangeData.getChainId();
                if (verifierChainId == chainId) {
                    LocalVerifierManager.localVerifierChangeRollback(chain, verifierChangeData.getCancelAgentList(), verifierChangeData.getRegisterAgentList(), blockHeader.getHeight(), ctxHash);
                    continue;
                }
                ChainInfo chainInfo = this.chainManager.getChainInfo(verifierChainId);
                if (registerList != null && !registerList.isEmpty()) {
                    chainInfo.getVerifierList().removeAll(registerList);
                }
                if (cancelList != null && !cancelList.isEmpty()) {
                    chainInfo.getVerifierList().addAll(cancelList);
                }
                RegisteredChainMessage registeredChainMessage = new RegisteredChainMessage();
                registeredChainMessage.setChainInfoList(this.chainManager.getRegisteredCrossChainList());
                if (this.registeredCrossChainService.save(registeredChainMessage)) continue;
                return false;
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                return false;
            }
        }
        return true;
    }
}

