/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.srorage.imp;

import io.nuls.base.data.NulsHash;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.crosschain.srorage.ConvertHashService;
import java.util.ArrayList;
import java.util.List;

@Component
public class ConvertHashServiceImpl
implements ConvertHashService {
    @Override
    public boolean save(NulsHash originalHash, NulsHash localHash, int chainID) {
        if (originalHash == null || localHash == null) {
            return false;
        }
        try {
            return RocksDBService.put((String)("convert_hash_ctx" + chainID), (byte[])originalHash.getBytes(), (byte[])localHash.getBytes());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public NulsHash get(NulsHash originalHash, int chainID) {
        if (originalHash == null) {
            return null;
        }
        try {
            byte[] valueBytes = RocksDBService.get((String)("convert_hash_ctx" + chainID), (byte[])originalHash.getBytes());
            if (valueBytes == null) {
                return null;
            }
            return new NulsHash(valueBytes);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean delete(NulsHash originalHash, int chainID) {
        try {
            if (originalHash == null) {
                return false;
            }
            return RocksDBService.delete((String)("convert_hash_ctx" + chainID), (byte[])originalHash.getBytes());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public List<NulsHash> getList(int chainID) {
        try {
            List list = RocksDBService.entryList((String)("convert_hash_ctx" + chainID));
            ArrayList<NulsHash> hashList = new ArrayList<NulsHash>();
            for (Entry entry : list) {
                NulsHash localHash = new NulsHash((byte[])entry.getValue());
                hashList.add(localHash);
            }
            return hashList;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }
}

