/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.manager;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.dto.input.CoinDTO;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.LedgerCall;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Component
public class CoinDataManager {
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private ChainManager chainManager;

    public List<CoinFrom> assemblyCoinFrom(Chain chain, List<CoinDTO> listFrom, boolean isMultiSign) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        byte[] multiAddress = null;
        for (CoinDTO coinDTO : listFrom) {
            String addressStr = coinDTO.getAddress();
            byte[] address = AddressTool.getAddress((String)addressStr);
            if (isMultiSign) {
                if (null == multiAddress) {
                    multiAddress = address;
                } else if (!Arrays.equals(multiAddress, address)) {
                    chain.getLogger().error("Multiple account transfers are not supported with multiple signatures");
                    throw new NulsException(NulsCrossChainErrorCode.ONLY_ONE_MULTI_SIGNATURE_ADDRESS_ALLOWED);
                }
                if (!AddressTool.isMultiSignAddress((byte[])address)) {
                    chain.getLogger().error("Ordinary accounts do not allow sending multiple account transfer transactions");
                    throw new NulsException(NulsCrossChainErrorCode.IS_NOT_MULTI_SIGNATURE_ADDRESS);
                }
            } else if (AddressTool.isMultiSignAddress((byte[])address)) {
                chain.getLogger().error("Multiple signature accounts are not allowed in regular account transfers");
                throw new NulsException(NulsCrossChainErrorCode.IS_MULTI_SIGNATURE_ADDRESS);
            }
            if (!AddressTool.validAddress((int)chain.getChainId(), (String)addressStr)) {
                chain.getLogger().error("Cross chain transaction transfer out account is not a local chain account");
                throw new NulsException(NulsCrossChainErrorCode.ADDRESS_IS_NOT_THE_CURRENT_CHAIN);
            }
            int assetChainId = coinDTO.getAssetsChainId();
            int assetId = coinDTO.getAssetsId();
            BigInteger amount = coinDTO.getAmount();
            Map<String, Object> result = LedgerCall.getBalanceAndNonce(chain, addressStr, assetChainId, assetId);
            byte[] nonce = RPCUtil.decode((String)((String)result.get("nonce")));
            BigInteger balance = new BigInteger(result.get("available").toString());
            if (BigIntegerUtils.isLessThan((BigInteger)balance, (BigInteger)amount)) {
                chain.getLogger().error("Insufficient account balance");
                throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_BALANCE);
            }
            CoinFrom coinFrom = new CoinFrom(address, assetChainId, assetId, amount, nonce, 0);
            coinFroms.add(coinFrom);
        }
        return coinFroms;
    }

    public List<CoinTo> assemblyCoinTo(List<CoinDTO> listTo, Chain chain) throws NulsException {
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        int receiveChainId = 0;
        for (CoinDTO coinDTO : listTo) {
            byte[] address = AddressTool.getAddress((String)coinDTO.getAddress());
            if (0 == receiveChainId) {
                receiveChainId = AddressTool.getChainIdByAddress((byte[])address);
            } else if (receiveChainId != AddressTool.getChainIdByAddress((byte[])address)) {
                chain.getLogger().error("There are multiple consecutive payees");
                throw new NulsException(NulsCrossChainErrorCode.CROSS_TX_PAYEE_CHAIN_NOT_SAME);
            }
            CoinTo coinTo = new CoinTo();
            coinTo.setAddress(address);
            int chainId = coinDTO.getAssetsChainId();
            int assetId = coinDTO.getAssetsId();
            coinTo.setAmount(coinDTO.getAmount());
            coinTo.setAssetsChainId(chainId);
            coinTo.setAssetsId(assetId);
            coinTos.add(coinTo);
        }
        return coinTos;
    }

    public void verifyCoin(List<CoinFrom> coinFromList, List<CoinTo> coinToList, Chain chain) throws NulsException {
        if (coinFromList.size() == 0 || coinToList.size() == 0) {
            chain.getLogger().error("The payer or payee is empty");
            throw new NulsException(NulsCrossChainErrorCode.COINDATA_IS_INCOMPLETE);
        }
        byte[] toAddress = coinToList.get(0).getAddress();
        int toChainId = AddressTool.getChainIdByAddress((byte[])toAddress);
        byte[] fromAddress = coinFromList.get(0).getAddress();
        int fromChainId = AddressTool.getChainIdByAddress((byte[])fromAddress);
        if (fromChainId == toChainId) {
            chain.getLogger().error("The payer and payee of cross chain transactions cannot be the same chain account");
            throw new NulsException(NulsCrossChainErrorCode.PAYEE_AND_PAYER_IS_THE_SAME_CHAIN);
        }
        if (!chain.isMainChain()) {
            boolean fromChainRegistered = false;
            boolean toChainRegistered = false;
            for (ChainInfo chainInfo : this.chainManager.getRegisteredCrossChainList()) {
                if (!fromChainRegistered && chainInfo.getChainId() == fromChainId) {
                    fromChainRegistered = true;
                }
                if (!toChainRegistered && chainInfo.getChainId() == toChainId) {
                    toChainRegistered = true;
                }
                if (!fromChainRegistered || !toChainRegistered) continue;
                break;
            }
            if (!fromChainRegistered) {
                chain.getLogger().error("This chain{}Cross chain registration not yet registered", new Object[]{fromChainId});
                throw new NulsException(NulsCrossChainErrorCode.CURRENT_CHAIN_UNREGISTERED_CROSS_CHAIN);
            }
            if (!toChainRegistered) {
                chain.getLogger().error("Target Chain{}Cross chain registration not yet registered", new Object[]{toChainId});
                throw new NulsException(NulsCrossChainErrorCode.TARGET_CHAIN_UNREGISTERED_CROSS_CHAIN);
            }
            HashSet<CallSite> verifiedAssets = new HashSet<CallSite>();
            for (Coin coin : coinFromList) {
                ChainInfo chainInfo;
                String key = String.valueOf(coin.getAssetsChainId()) + "_" + coin.getAssetsId();
                if (verifiedAssets.contains(key)) continue;
                boolean assetAvailable = false;
                Iterator<ChainInfo> iterator = this.chainManager.getRegisteredCrossChainList().iterator();
                while (iterator.hasNext() && !(assetAvailable = (chainInfo = iterator.next()).verifyAssetAvailability(coin.getAssetsChainId(), coin.getAssetsId()))) {
                }
                if (!assetAvailable) {
                    chain.getLogger().error("chain{}Assets of{}Unregistered cross chain", new Object[]{coin.getAssetsChainId(), coin.getAssetsId()});
                    throw new NulsException(NulsCrossChainErrorCode.ASSET_UNREGISTERED_CROSS_CHAIN);
                }
                verifiedAssets.add((CallSite)((Object)key));
            }
        }
    }

    public CoinData getCrossCoinData(Chain chain, List<CoinFrom> listFrom, List<CoinTo> listTo, int txSize, boolean isMainNet) throws NulsException {
        CoinData coinData = new CoinData();
        coinData.setFrom(listFrom);
        coinData.setTo(listTo);
        txSize += coinData.size();
        BigInteger localFeeTotalFrom = BigInteger.ZERO;
        BigInteger crossFeeTotalFrom = BigInteger.ZERO;
        for (CoinFrom coinFrom : listFrom) {
            if (CommonUtil.isLocalAsset((Coin)coinFrom)) {
                localFeeTotalFrom = localFeeTotalFrom.add(coinFrom.getAmount());
                continue;
            }
            if (isMainNet || !CommonUtil.isNulsAsset((Coin)coinFrom)) continue;
            crossFeeTotalFrom = crossFeeTotalFrom.add(coinFrom.getAmount());
        }
        BigInteger localFeeTotalTo = BigInteger.ZERO;
        BigInteger crossFeeTotalTo = BigInteger.ZERO;
        for (CoinTo coinTo : listTo) {
            if (CommonUtil.isLocalAsset((Coin)coinTo)) {
                localFeeTotalTo = localFeeTotalTo.add(coinTo.getAmount());
                continue;
            }
            if (isMainNet || !CommonUtil.isNulsAsset((Coin)coinTo)) continue;
            crossFeeTotalTo = crossFeeTotalTo.add(coinTo.getAmount());
        }
        BigInteger targetFee = TransactionFeeCalculator.getCrossTxFee((int)txSize);
        BigInteger localActualFee = localFeeTotalFrom.subtract(localFeeTotalTo);
        if (BigIntegerUtils.isLessThan((BigInteger)localActualFee, (BigInteger)BigInteger.ZERO)) {
            chain.getLogger().error("The amount transferred out is less than the amount transferred in");
            throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
        }
        if (BigIntegerUtils.isLessThan((BigInteger)localActualFee, (BigInteger)targetFee) && BigIntegerUtils.isLessThan((BigInteger)(localActualFee = this.getFeeDirect(chain, listFrom, targetFee, localActualFee, true)), (BigInteger)targetFee) && !this.getFeeIndirect(chain, listFrom, txSize, targetFee, localActualFee, true)) {
            chain.getLogger().error("Insufficient balance");
            throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
        }
        if (!isMainNet) {
            BigInteger crossActualFee = crossFeeTotalFrom.subtract(crossFeeTotalTo);
            if (BigIntegerUtils.isLessThan((BigInteger)crossActualFee, (BigInteger)BigInteger.ZERO)) {
                chain.getLogger().error("The amount transferred out is less than the amount transferred in");
                throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
            }
            if (BigIntegerUtils.isLessThan((BigInteger)crossActualFee, (BigInteger)targetFee) && BigIntegerUtils.isLessThan((BigInteger)(crossActualFee = this.getFeeDirect(chain, listFrom, targetFee, crossActualFee, false)), (BigInteger)targetFee) && !this.getFeeIndirect(chain, listFrom, txSize, targetFee, crossActualFee, false)) {
                chain.getLogger().error("Insufficient balance");
                throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
            }
        }
        return coinData;
    }

    public CoinData getCoinData(Chain chain, List<CoinFrom> listFrom, List<CoinTo> listTo, int txSize, boolean isMainNet) throws NulsException {
        BigInteger feeTotalFrom = BigInteger.ZERO;
        for (CoinFrom coinFrom : listFrom) {
            txSize += coinFrom.size();
            if (isMainNet) {
                if (!CommonUtil.isLocalAsset((Coin)coinFrom)) continue;
                feeTotalFrom = feeTotalFrom.add(coinFrom.getAmount());
                continue;
            }
            if (!CommonUtil.isNulsAsset((Coin)coinFrom)) continue;
            feeTotalFrom = feeTotalFrom.add(coinFrom.getAmount());
        }
        BigInteger feeTotalTo = BigInteger.ZERO;
        for (CoinTo coinTo : listTo) {
            txSize += coinTo.size();
            if (isMainNet) {
                if (!CommonUtil.isLocalAsset((Coin)coinTo)) continue;
                feeTotalTo = feeTotalTo.add(coinTo.getAmount());
                continue;
            }
            if (!CommonUtil.isNulsAsset((Coin)coinTo)) continue;
            feeTotalTo = feeTotalTo.add(coinTo.getAmount());
        }
        BigInteger bigInteger = TransactionFeeCalculator.getCrossTxFee((int)txSize);
        BigInteger actualFee = feeTotalFrom.subtract(feeTotalTo);
        if (BigIntegerUtils.isLessThan((BigInteger)actualFee, (BigInteger)BigInteger.ZERO)) {
            chain.getLogger().error("The amount transferred out is less than the amount transferred in");
            throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
        }
        if (BigIntegerUtils.isLessThan((BigInteger)actualFee, (BigInteger)bigInteger) && BigIntegerUtils.isLessThan((BigInteger)(actualFee = this.getFeeDirect(chain, listFrom, bigInteger, actualFee, isMainNet)), (BigInteger)bigInteger) && !this.getFeeIndirect(chain, listFrom, txSize, bigInteger, actualFee, isMainNet)) {
            chain.getLogger().error("Insufficient balance");
            throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(listFrom);
        coinData.setTo(listTo);
        return coinData;
    }

    private BigInteger getFeeDirect(Chain chain, List<CoinFrom> listFrom, BigInteger targetFee, BigInteger actualFee, boolean isLocalFee) throws NulsException {
        int assertId;
        int chainId;
        if (!isLocalFee) {
            chainId = this.config.getMainChainId();
            assertId = this.config.getMainAssetId();
        } else {
            chainId = chain.getChainId();
            assertId = chain.getConfig().getAssetId();
        }
        for (CoinFrom coinFrom : listFrom) {
            BigInteger current;
            BigInteger balance;
            boolean isDirectCoin = isLocalFee && CommonUtil.isLocalAsset((Coin)coinFrom) || !isLocalFee && CommonUtil.isNulsAsset((Coin)coinFrom);
            if (!isDirectCoin || (balance = LedgerCall.getBalanceNonce(chain, coinFrom.getAddress(), chainId, assertId)).compareTo(BigInteger.ZERO) == 0) continue;
            if (BigIntegerUtils.isEqualOrGreaterThan((BigInteger)(balance = balance.subtract(coinFrom.getAmount())), (BigInteger)(current = targetFee.subtract(actualFee)))) {
                coinFrom.setAmount(coinFrom.getAmount().add(current));
                actualFee = actualFee.add(current);
                break;
            }
            if (!BigIntegerUtils.isGreaterThan((BigInteger)balance, (BigInteger)BigInteger.ZERO)) continue;
            coinFrom.setAmount(coinFrom.getAmount().add(balance));
            actualFee = actualFee.add(balance);
        }
        return actualFee;
    }

    private boolean getFeeIndirect(Chain chain, List<CoinFrom> listFrom, int txSize, BigInteger targetFee, BigInteger actualFee, boolean isLocalFee) throws NulsException {
        int assertId;
        int chainId;
        if (!isLocalFee) {
            chainId = this.config.getMainChainId();
            assertId = this.config.getMainAssetId();
        } else {
            chainId = chain.getChainId();
            assertId = chain.getConfig().getAssetId();
        }
        ArrayList<CoinFrom> newCoinFromList = new ArrayList<CoinFrom>();
        for (CoinFrom coinFrom : listFrom) {
            BigInteger balance;
            boolean isDirectCoin = isLocalFee && CommonUtil.isLocalAsset((Coin)coinFrom) || !isLocalFee && CommonUtil.isNulsAsset((Coin)coinFrom);
            if (isDirectCoin || BigIntegerUtils.isEqualOrLessThan((BigInteger)(balance = LedgerCall.getBalanceNonce(chain, coinFrom.getAddress(), chainId, assertId)), (BigInteger)BigInteger.ZERO)) continue;
            CoinFrom feeCoinFrom = new CoinFrom();
            byte[] address = coinFrom.getAddress();
            feeCoinFrom.setAddress(address);
            feeCoinFrom.setNonce(LedgerCall.getNonce(chain, AddressTool.getStringAddressByBytes((byte[])address), chainId, assertId));
            targetFee = TransactionFeeCalculator.getCrossTxFee((int)(txSize += feeCoinFrom.size()));
            BigInteger current = targetFee.subtract(actualFee);
            BigInteger fee = BigIntegerUtils.isEqualOrGreaterThan((BigInteger)balance, (BigInteger)current) ? current : balance;
            feeCoinFrom.setLocked((byte)0);
            feeCoinFrom.setAssetsChainId(chainId);
            feeCoinFrom.setAssetsId(assertId);
            feeCoinFrom.setAmount(fee);
            newCoinFromList.add(feeCoinFrom);
            if (!BigIntegerUtils.isEqualOrGreaterThan((BigInteger)(actualFee = actualFee.add(fee)), (BigInteger)targetFee)) continue;
            break;
        }
        listFrom.addAll(newCoinFromList);
        return BigIntegerUtils.isEqualOrGreaterThan((BigInteger)actualFee, (BigInteger)targetFee);
    }

    public int getSignatureSize(List<CoinFrom> coinFroms) {
        int size = 0;
        HashSet<String> signAddress = new HashSet<String>();
        for (CoinFrom coinFrom : coinFroms) {
            byte[] address = coinFrom.getAddress();
            signAddress.add(AddressTool.getStringAddressByBytes((byte[])address));
        }
        return size += signAddress.size() * 110;
    }
}

