/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.thread.handler;

import io.nuls.crosschain.base.message.BroadCtxSignMessage;
import io.nuls.crosschain.base.utils.HashSetTimeDuplicateProcessor;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.utils.MessageUtil;

public class SignMessageByzantineHandler
implements Runnable {
    private Chain chain;
    private HashSetTimeDuplicateProcessor processor = new HashSetTimeDuplicateProcessor(1000, 300000L);

    public SignMessageByzantineHandler(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void run() {
        while (this.chain.getSignMessageByzantineQueue() != null) {
            try {
                UntreatedMessage untreatedMessage = this.chain.getSignMessageByzantineQueue().take();
                this.chain.getLogger().info("D process \uff1a " + untreatedMessage.getNodeId() + "," + untreatedMessage.getCacheHash().toHex());
                String nativeHex = untreatedMessage.getCacheHash().toHex();
                this.chain.getLogger().debug("Start monitoring nodes within the chain{}Cross chain transaction signature message broadcasted for signature Byzantine verification,Hash\uff1a{}", new Object[]{untreatedMessage.getNodeId(), nativeHex});
                MessageUtil.handleSignMessage(this.chain, untreatedMessage.getCacheHash(), untreatedMessage.getChainId(), untreatedMessage.getNodeId(), (BroadCtxSignMessage)untreatedMessage.getMessage(), nativeHex);
            }
            catch (Exception e) {
                this.chain.getLogger().error(e);
            }
        }
    }
}

