/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger;

import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.manager.LedgerChainManager;
import io.nuls.ledger.utils.LoggerUtil;

@Component
public class LedgerBootstrap
implements INulsCoresBootstrap {
    @Autowired
    NulsCoresConfig ledgerConfig;
    @Autowired
    AddressPrefixDatas addressPrefixDatas;

    @Override
    public int order() {
        return 5;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.LG.abbr, "1.0");
    }

    public void init() {
        try {
            LedgerConstant.UNCONFIRM_NONCE_EXPIRED_TIME = this.ledgerConfig.getUnconfirmedTxExpired();
            LedgerConstant.DEFAULT_ENCODING = this.ledgerConfig.getEncoding();
            LedgerConstant.blackHolePublicKey = HexUtil.decode((String)this.ledgerConfig.getBlackHolePublicKey());
            LedgerChainManager ledgerChainManager = (LedgerChainManager)SpringLiteContext.getBean(LedgerChainManager.class);
            ledgerChainManager.initChains();
            LoggerUtil.COMMON_LOG.info("Ledger data init complete!");
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            LoggerUtil.COMMON_LOG.error("start fail...");
            System.exit(-1);
        }
    }

    @Override
    public void onDependenciesReady() {
        try {
            LedgerChainManager ledgerChainManager = (LedgerChainManager)SpringLiteContext.getBean(LedgerChainManager.class);
            ledgerChainManager.syncBlockHeight();
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            System.exit(-1);
        }
    }
}

