/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.model.po.sub.FreezeHeightState;
import io.nuls.ledger.model.po.sub.FreezeLockTimeState;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class AccountState
extends BaseNulsData {
    private byte[] nonce = LedgerConstant.getInitNonceByte();
    private long latestUnFreezeTime = 0L;
    private BigInteger totalFromAmount = BigInteger.ZERO;
    private BigInteger totalToAmount = BigInteger.ZERO;
    private List<FreezeHeightState> freezeHeightStates = new ArrayList<FreezeHeightState>();
    private List<FreezeLockTimeState> freezeLockTimeStates = new ArrayList<FreezeLockTimeState>();

    public AccountState() {
    }

    public AccountState(byte[] pNonce) {
        System.arraycopy(pNonce, 0, this.nonce, 0, 8);
    }

    public BigInteger getAvailableAmount() {
        return this.totalToAmount.subtract(this.totalFromAmount);
    }

    public void addTotalFromAmount(BigInteger value) {
        this.totalFromAmount = this.totalFromAmount.add(value);
    }

    public void addTotalToAmount(BigInteger value) {
        this.totalToAmount = this.totalToAmount.add(value);
    }

    public BigInteger getTotalAmount() {
        return this.totalToAmount.subtract(this.totalFromAmount).add(this.getFreezeTotal());
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.nonce);
        stream.writeUint32(this.latestUnFreezeTime);
        stream.writeBigInteger(this.totalFromAmount);
        stream.writeBigInteger(this.totalToAmount);
        stream.writeUint32((long)this.freezeHeightStates.size());
        for (FreezeHeightState heightState : this.freezeHeightStates) {
            stream.writeNulsData((BaseNulsData)heightState);
        }
        stream.writeUint32((long)this.freezeLockTimeStates.size());
        for (FreezeLockTimeState lockTimeState : this.freezeLockTimeStates) {
            stream.writeNulsData((BaseNulsData)lockTimeState);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.nonce = byteBuffer.readBytes(8);
        this.latestUnFreezeTime = byteBuffer.readUint32();
        this.totalFromAmount = byteBuffer.readBigInteger();
        this.totalToAmount = byteBuffer.readBigInteger();
        int freezeHeightCount = (int)byteBuffer.readUint32();
        this.freezeHeightStates = new ArrayList<FreezeHeightState>(freezeHeightCount);
        for (int i = 0; i < freezeHeightCount; ++i) {
            try {
                FreezeHeightState heightState = new FreezeHeightState();
                byteBuffer.readNulsData((BaseNulsData)heightState);
                this.freezeHeightStates.add(heightState);
                continue;
            }
            catch (Exception e) {
                throw new NulsException((Throwable)e);
            }
        }
        int freezeLockTimeCount = (int)byteBuffer.readUint32();
        this.freezeLockTimeStates = new ArrayList<FreezeLockTimeState>(freezeLockTimeCount);
        for (int i = 0; i < freezeLockTimeCount; ++i) {
            try {
                FreezeLockTimeState lockTimeState = new FreezeLockTimeState();
                byteBuffer.readNulsData((BaseNulsData)lockTimeState);
                this.freezeLockTimeStates.add(lockTimeState);
                continue;
            }
            catch (Exception e) {
                throw new NulsException((Throwable)e);
            }
        }
    }

    public int size() {
        int size = 0;
        size += this.nonce.length;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfUint32();
        for (FreezeHeightState heightState : this.freezeHeightStates) {
            size += SerializeUtils.sizeOfNulsData((NulsData)heightState);
        }
        size += SerializeUtils.sizeOfUint32();
        for (FreezeLockTimeState lockTimeState : this.freezeLockTimeStates) {
            size += SerializeUtils.sizeOfNulsData((NulsData)lockTimeState);
        }
        return size;
    }

    public BigInteger getFreezeTotal() {
        BigInteger freeze = BigInteger.ZERO;
        for (FreezeHeightState heightState : this.freezeHeightStates) {
            freeze = freeze.add(heightState.getAmount());
        }
        for (FreezeLockTimeState lockTimeState : this.freezeLockTimeStates) {
            freeze = freeze.add(lockTimeState.getAmount());
        }
        return freeze;
    }

    public AccountState deepClone() {
        AccountState orgAccountState = new AccountState();
        orgAccountState.setNonce(ByteUtils.copyOf((byte[])this.getNonce(), (int)8));
        orgAccountState.setLatestUnFreezeTime(this.getLatestUnFreezeTime());
        orgAccountState.setTotalFromAmount(this.getTotalFromAmount());
        orgAccountState.setTotalToAmount(this.getTotalToAmount());
        ArrayList<FreezeHeightState> heightStateArrayList = new ArrayList<FreezeHeightState>();
        heightStateArrayList.addAll(this.getFreezeHeightStates());
        orgAccountState.setFreezeHeightStates(heightStateArrayList);
        ArrayList<FreezeLockTimeState> lockTimeStateArrayList = new ArrayList<FreezeLockTimeState>();
        lockTimeStateArrayList.addAll(this.getFreezeLockTimeStates());
        orgAccountState.setFreezeLockTimeStates(lockTimeStateArrayList);
        return orgAccountState;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public long getLatestUnFreezeTime() {
        return this.latestUnFreezeTime;
    }

    public void setLatestUnFreezeTime(long latestUnFreezeTime) {
        this.latestUnFreezeTime = latestUnFreezeTime;
    }

    public BigInteger getTotalFromAmount() {
        return this.totalFromAmount;
    }

    public void setTotalFromAmount(BigInteger totalFromAmount) {
        this.totalFromAmount = totalFromAmount;
    }

    public BigInteger getTotalToAmount() {
        return this.totalToAmount;
    }

    public void setTotalToAmount(BigInteger totalToAmount) {
        this.totalToAmount = totalToAmount;
    }

    public List<FreezeHeightState> getFreezeHeightStates() {
        return this.freezeHeightStates;
    }

    public void setFreezeHeightStates(List<FreezeHeightState> freezeHeightStates) {
        this.freezeHeightStates = freezeHeightStates;
    }

    public List<FreezeLockTimeState> getFreezeLockTimeStates() {
        return this.freezeLockTimeStates;
    }

    public void setFreezeLockTimeStates(List<FreezeLockTimeState> freezeLockTimeStates) {
        this.freezeLockTimeStates = freezeLockTimeStates;
    }

    public boolean timeAllow() {
        long now = NulsDateUtils.getCurrentTimeSeconds();
        return now - this.latestUnFreezeTime > 1L;
    }
}

