/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.network.constant.ManagerStatusEnum;
import io.nuls.network.constant.NetworkErrorCode;
import io.nuls.network.manager.BaseManager;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.MessageHandlerFactory;
import io.nuls.network.manager.handler.base.BaseMeesageHandlerInf;
import io.nuls.network.manager.handler.message.OtherModuleMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.model.dto.PeerCacheMessage;
import io.nuls.network.model.message.AddrMessage;
import io.nuls.network.model.message.GetAddrMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.base.MessageHeader;
import io.nuls.network.utils.LoggerUtil;
import io.nuls.network.utils.MessageUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MessageManager
extends BaseManager {
    private static MessageManager instance = new MessageManager();

    public static MessageManager getInstance() {
        return instance;
    }

    public void sendToNode(BaseMessage message, Node node, boolean aysn) {
        this.broadcastToANode(message, node, aysn);
    }

    public void sendHandlerMsg(BaseMessage message, Node node, boolean aysn) {
        BaseMeesageHandlerInf handler = MessageHandlerFactory.getInstance().getHandler(message.getHeader().getCommandStr());
        handler.send(message, node, aysn);
    }

    public long getCheckSum(byte[] msgBody) {
        byte[] bodyHash = Sha256Hash.hashTwice((byte[])msgBody);
        byte[] get4Byte = ByteUtils.subBytes((byte[])bodyHash, (int)0, (int)4);
        return ByteUtils.bytesToBigInteger((byte[])get4Byte).longValue();
    }

    private BaseMessage getMessageInstance(String command) {
        Class<? extends BaseMessage> msgClass = MessageFactory.getMessage(command);
        if (null == msgClass) {
            return null;
        }
        try {
            return msgClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Log.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.error((Throwable)e);
        }
        return null;
    }

    private boolean validate(byte[] data, long pChecksum) {
        byte[] bodyHash = Sha256Hash.hashTwice((byte[])data);
        byte[] get4Byte = ByteUtils.subBytes((byte[])bodyHash, (int)0, (int)4);
        long checksum = ByteUtils.bytesToBigInteger((byte[])get4Byte).longValue();
        return checksum == pChecksum;
    }

    public void receiveMessage(NulsByteBuffer byteBuffer, Node node) {
        if (null == byteBuffer) {
            return;
        }
        MessageHeader header = new MessageHeader();
        Object message = null;
        try {
            int headerSize = header.size();
            byte[] payLoad = byteBuffer.getPayload();
            byte[] payLoadBody = ByteUtils.subBytes((byte[])payLoad, (int)headerSize, (int)(payLoad.length - headerSize));
            byte[] headerByte = ByteUtils.copyOf((byte[])payLoad, (int)headerSize);
            int chainId = NodeGroupManager.getInstance().getChainIdByMagicNum(header.getMagicNumber());
            header.parse(headerByte, 0);
            if (!this.validate(payLoadBody, header.getChecksum())) {
                LoggerUtil.logger(chainId).error("validate  false ======================cmd:{}", new Object[]{header.getCommandStr()});
                return;
            }
            message = MessageManager.getInstance().getMessageInstance(header.getCommandStr());
            byteBuffer.setCursor(0);
            while (!byteBuffer.isFinished()) {
                BaseMeesageHandlerInf handler;
                NetworkEventResult result = null;
                if (null != message) {
                    message = (BaseMessage)byteBuffer.readNulsData((BaseNulsData)message);
                    handler = MessageHandlerFactory.getInstance().getHandler(header.getCommandStr());
                    result = handler.recieve((BaseMessage)((Object)message), node);
                } else {
                    handler = MessageHandlerFactory.getInstance().getOtherModuleHandler();
                    result = ((OtherModuleMessageHandler)handler).recieve(header, payLoadBody, node);
                    byteBuffer.setCursor(payLoad.length);
                }
                if (result.isSuccess()) continue;
                LoggerUtil.logger(chainId).error("receiveMessage deal fail:" + result.getErrorCode().getMsg());
            }
        }
        catch (Exception e) {
            if (null != message) {
                Log.error((String)"node==={} , {} , {} , {}", (Object[])new Object[]{node.getId(), HexUtil.encode((byte[])byteBuffer.getPayload()), header.getCommandStr(), message.getClass().getTypeName()});
            } else {
                Log.error((String)"node==={} , {} , {}", (Object[])new Object[]{node.getId(), HexUtil.encode((byte[])byteBuffer.getPayload()), header.getCommandStr()});
            }
            Log.error((String)"", (Throwable)e);
        }
    }

    public NetworkEventResult broadcastSelfAddrToAllNode(Collection<Node> connectNodes, IpAddressShare ipAddress, boolean isCrossAddress, boolean asyn) {
        for (Node connectNode : connectNodes) {
            ArrayList<IpAddressShare> addressesList = new ArrayList<IpAddressShare>();
            addressesList.add(ipAddress);
            AddrMessage addrMessage = MessageFactory.getInstance().buildAddrMessage(addressesList, connectNode.getMagicNumber(), connectNode.getNodeGroup().getChainId(), isCrossAddress ? (byte)1 : 0);
            LoggerUtil.logger(connectNode.getNodeGroup().getChainId()).info("broadcastSelfAddrToAllNode===node={}", new Object[]{connectNode.getId()});
            this.sendToNode(addrMessage, connectNode, asyn);
        }
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
    }

    public void sendGetAddressMessage(NodeGroup nodeGroup, boolean isConnectCross, boolean isCrossAddress, boolean asyn) {
        LoggerUtil.logger(nodeGroup.getChainId()).info("sendGetAddrMessage chainId={},isCross={}", new Object[]{nodeGroup.getChainId(), isConnectCross});
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (isConnectCross) {
            nodes.addAll(nodeGroup.getCrossNodeContainer().getConnectedNodes().values());
        } else {
            nodes.addAll(nodeGroup.getLocalNetNodeContainer().getConnectedNodes().values());
        }
        for (Node node : nodes) {
            if (5 != node.getConnectStatus()) continue;
            GetAddrMessage getAddrMessage = MessageFactory.getInstance().buildGetAddrMessage(nodeGroup, isCrossAddress);
            this.sendHandlerMsg(getAddrMessage, node, asyn);
        }
    }

    public void sendGetAddressMessage(Node node, boolean isConnectCross, boolean isCrossAddress, boolean asyn) {
        if (5 == node.getConnectStatus()) {
            GetAddrMessage getAddrMessage = MessageFactory.getInstance().buildGetAddrMessage(node.getNodeGroup(), isCrossAddress);
            this.sendHandlerMsg(getAddrMessage, node, asyn);
        }
    }

    public void sendGetCrossAddressMessage(NodeGroup connectNodeGroup, NodeGroup messageNodeGroup, boolean isConnectCross, boolean isCrossAddress, boolean asyn) {
        LoggerUtil.logger(connectNodeGroup.getChainId()).info("sendGetAddrMessage chainId={},isCross={},getCrossAddress={}", new Object[]{connectNodeGroup.getChainId(), isConnectCross, isCrossAddress});
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (isConnectCross) {
            nodes.addAll(connectNodeGroup.getCrossNodeContainer().getConnectedNodes().values());
        } else {
            nodes.addAll(connectNodeGroup.getLocalNetNodeContainer().getConnectedNodes().values());
        }
        for (Node node : nodes) {
            if (5 != node.getConnectStatus()) continue;
            GetAddrMessage getAddrMessage = MessageFactory.getInstance().buildGetAddrMessage(messageNodeGroup.getChainId(), connectNodeGroup.getMagicNumber(), isCrossAddress);
            this.sendHandlerMsg(getAddrMessage, node, asyn);
        }
    }

    public NetworkEventResult broadcastToAllNode(BaseMessage message, Node excludeNode, boolean isCross, boolean asyn) {
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByMagic(message.getHeader().getMagicNumber());
        Collection<Node> connectNodes = null;
        if (isCross) {
            return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
        }
        connectNodes = nodeGroup.getLocalNetNodeContainer().getConnectedNodes().values();
        if (null != connectNodes && connectNodes.size() > 0) {
            for (Node connectNode : connectNodes) {
                if (null != excludeNode && connectNode.getId().equals(excludeNode.getId())) continue;
                this.sendToNode(message, connectNode, asyn);
            }
        }
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
    }

    public NetworkEventResult broadcastNewAddr(BaseMessage message, Node excludeNode, boolean isCross, boolean asyn) {
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByMagic(message.getHeader().getMagicNumber());
        List<Node> connectNodes = null;
        connectNodes = isCross ? nodeGroup.getCrossNodeContainer().getAvailableNodes() : nodeGroup.getLocalNetNodeContainer().getAvailableNodes();
        if (null != connectNodes && connectNodes.size() > 0) {
            for (Node connectNode : connectNodes) {
                if (null != excludeNode && connectNode.getId().equals(excludeNode.getId())) continue;
                this.sendHandlerMsg(message, connectNode, asyn);
            }
        }
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
    }

    private boolean isHandShakeMessage(BaseMessage message) {
        return message.getHeader().getCommandStr().equals("version") || message.getHeader().getCommandStr().equals("verAck");
    }

    private NetworkEventResult broadcastToANode(BaseMessage message, Node node, boolean asyn) {
        if (!this.isHandShakeMessage(message) && 5 != node.getConnectStatus()) {
            Log.error((String)"============={} status is not handshake(AVAILABLE)", (Object[])new Object[]{node.getId()});
            return new NetworkEventResult(false, NetworkErrorCode.NET_NODE_DEAD);
        }
        if (node.getChannel() == null || !node.getChannel().isActive()) {
            Log.error((String)"============={} getChannel is not Active", (Object[])new Object[]{node.getId()});
            return new NetworkEventResult(false, NetworkErrorCode.NET_NODE_MISS_CHANNEL);
        }
        try {
            MessageHeader header = message.getHeader();
            Object body = message.getMsgBody();
            header.setPayloadLength(body.size());
            if (asyn) {
                node.getChannel().eventLoop().execute(() -> {
                    Channel channel = node.getChannel();
                    if (channel != null) {
                        try {
                            if (!channel.isWritable()) {
                                LoggerUtil.COMMON_LOG.error("#### isWritable=false,send fail.node={},cmd={}", new Object[]{node.getId(), header.getCommandStr()});
                            }
                            channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])message.serialize()));
                        }
                        catch (IOException e) {
                            LoggerUtil.COMMON_LOG.error((Exception)e);
                        }
                    }
                });
            } else {
                ChannelFuture future = node.getChannel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])message.serialize()));
                future.await();
                boolean success = future.isSuccess();
                if (!success) {
                    return new NetworkEventResult(false, NetworkErrorCode.NET_BROADCAST_FAIL);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return new NetworkEventResult(false, NetworkErrorCode.NET_MESSAGE_ERROR);
        }
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
    }

    public NetworkEventResult broadcastToNodes(byte[] message, String cmd, List<Node> nodes, boolean asyn, int percent) {
        if (nodes.size() > 7 && percent < 100) {
            Collections.shuffle(nodes);
            double d = BigDecimal.valueOf(percent).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_DOWN).doubleValue();
            int toIndex = (int)((double)nodes.size() * d);
            if (toIndex < 7) {
                toIndex = 7;
            }
            nodes = nodes.subList(0, toIndex);
        }
        for (Node node : nodes) {
            if (node.getChannel() == null || !node.getChannel().isActive()) {
                Log.info((String)"broadcastToNodes node={} is not Active", (Object[])new Object[]{node.getId()});
                continue;
            }
            try {
                if (asyn) {
                    node.getChannel().eventLoop().execute(() -> {
                        Channel channel = node.getChannel();
                        if (channel != null) {
                            if (!channel.isWritable()) {
                                if (!MessageUtil.isLowerLeverCmd(cmd)) {
                                    LoggerUtil.COMMON_LOG.debug("#### isWritable=false,node={},cmd={} add to cache", new Object[]{node.getId(), cmd});
                                    node.getCacheSendMsgQueue().addLast(new PeerCacheMessage(message));
                                } else {
                                    LoggerUtil.COMMON_LOG.debug("#### isWritable=false,node={},cmd={} send to peer is drop", new Object[]{node.getId(), cmd});
                                }
                            } else {
                                channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])message));
                            }
                        }
                    });
                    continue;
                }
                ChannelFuture future = node.getChannel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])message));
                future.await();
                boolean success = future.isSuccess();
                if (success) continue;
                return new NetworkEventResult(false, NetworkErrorCode.NET_BROADCAST_FAIL);
            }
            catch (Exception e) {
                Log.error((Throwable)e);
            }
        }
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
    }

    @Override
    public void init() throws Exception {
        MessageFactory.getInstance().init();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void change(ManagerStatusEnum toStatus) throws Exception {
    }
}

