/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.BestBlockInfo;
import io.nuls.network.model.message.VerackMessage;
import io.nuls.network.model.message.VersionMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.VerackMessageBody;
import io.nuls.network.model.message.body.VersionMessageBody;
import io.nuls.network.netty.container.NodesContainer;
import io.nuls.network.rpc.call.BlockRpcService;
import io.nuls.network.rpc.call.impl.BlockRpcServiceImpl;
import io.nuls.network.utils.LoggerUtil;
import java.util.Map;

public class VersionMessageHandler
extends BaseMessageHandler {
    private static VersionMessageHandler instance = new VersionMessageHandler();
    private NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();

    private VersionMessageHandler() {
    }

    public static VersionMessageHandler getInstance() {
        return instance;
    }

    private boolean canConnectIn(int chainId, NodesContainer nodesContainer, int maxInCount, int sameIpMaxCount, String ip, int port) {
        int size = nodesContainer.getConnectedCount(1);
        if (size >= maxInCount) {
            LoggerUtil.logger(chainId).info("refuse canConnectIn size={},maxInCount={},node={}:{}", new Object[]{size, maxInCount, ip, port});
            return false;
        }
        Map<String, Node> connectedNodes = nodesContainer.getConnectedNodes();
        int sameIpCount = 0;
        for (Node node : connectedNodes.values()) {
            if (ip.equals(node.getIp()) && node.getType() == 2) {
                LoggerUtil.logger(chainId).info("refuse canConnectIn ip={},node.getIp()={}, node.getType={}", new Object[]{ip, node.getIp(), node.getType()});
                return false;
            }
            if (ip.equals(node.getIp())) {
                ++sameIpCount;
            }
            if (sameIpCount < sameIpMaxCount) continue;
            LoggerUtil.logger(chainId).info("refuse canConnectIn ip={},sameIpCount={},sameIpMaxCount={}, node.getType={}", new Object[]{ip, sameIpCount, sameIpMaxCount, node.getType()});
            return false;
        }
        return true;
    }

    private void serverRecieveHandler(BaseMessage message, Node node) {
        int maxIn;
        VersionMessageBody versionBody = (VersionMessageBody)((Object)message.getMsgBody());
        NodeGroup nodeGroup = this.nodeGroupManager.getNodeGroupByMagic(message.getHeader().getMagicNumber());
        String myIp = versionBody.getAddrYou().getIp().getHostAddress();
        int myPort = versionBody.getAddrYou().getPort();
        node.setMagicNumber(nodeGroup.getMagicNumber());
        String ip = node.getIp();
        node.setExternalIp(myIp);
        NodesContainer nodesContainer = null;
        int sameIpMaxCount = nodeGroup.getSameIpMaxCount(node.isCrossConnect());
        if (node.isCrossConnect()) {
            if (nodeGroup.isMoonGroup()) {
                LoggerUtil.logger(nodeGroup.getChainId()).error("node={} version canConnectIn fail..Cross=true, but group is moon net", new Object[]{node.getId()});
                node.getChannel().close();
                return;
            }
            BlockRpcService blockRpcService = (BlockRpcService)SpringLiteContext.getBean(BlockRpcServiceImpl.class);
            if (!nodeGroup.isMoonNode() && !nodeGroup.isHadBlockHeigh()) {
                BestBlockInfo bestBlockInfo = blockRpcService.getBestBlockHeader(nodeGroup.getChainId());
                if (bestBlockInfo.getBlockHeight() < 1L) {
                    LoggerUtil.logger(nodeGroup.getChainId()).error("node={} version canConnectIn fail..Cross=true, but blockHeight={}", new Object[]{bestBlockInfo.getBlockHeight()});
                    node.getChannel().close();
                    return;
                }
                nodeGroup.setHadBlockHeigh(true);
            }
            maxIn = nodeGroup.getMaxCrossIn();
            nodesContainer = nodeGroup.getCrossNodeContainer();
        } else {
            maxIn = nodeGroup.getMaxIn();
            nodesContainer = nodeGroup.getLocalNetNodeContainer();
        }
        if (!this.canConnectIn(nodeGroup.getChainId(), nodesContainer, maxIn, sameIpMaxCount, node.getIp(), node.getRemotePort())) {
            LoggerUtil.logger(nodeGroup.getChainId()).info("node={} version canConnectIn fail...cross={}", new Object[]{node.getId(), node.isCrossConnect()});
            node.getChannel().close();
            return;
        }
        node.setConnectStatus(2);
        nodesContainer.getConnectedNodes().put(node.getId(), node);
        nodesContainer.markCanuseNodeByIp(ip, 1);
        node.setDisconnectListener(() -> {
            if (node.isCrossConnect()) {
                nodeGroup.getCrossNodeContainer().getConnectedNodes().remove(node.getId());
                nodeGroup.getCrossNodeContainer().markCanuseNodeByIp(ip, 2);
            } else {
                nodeGroup.getLocalNetNodeContainer().getConnectedNodes().remove(node.getId());
                nodeGroup.getLocalNetNodeContainer().markCanuseNodeByIp(ip, 2);
            }
        });
        node.setVersionProtocolInfos(versionBody.getProtocolVersion(), versionBody.getBlockHeight(), versionBody.getBlockHash());
        VersionMessage versionMessage = MessageFactory.getInstance().buildVersionMessage(node, message.getHeader().getMagicNumber());
        LoggerUtil.logger(nodeGroup.getChainId()).info("rec node={} ver msg success.go response versionMessage..cross={}", new Object[]{node.getId(), node.isCrossConnect()});
        this.send(versionMessage, node, true);
    }

    private void clientRecieveHandler(BaseMessage message, Node node) {
        VersionMessageBody versionBody = (VersionMessageBody)((Object)message.getMsgBody());
        String myIp = versionBody.getAddrYou().getIp().getHostAddress();
        int myPort = versionBody.getAddrYou().getPort();
        node.setExternalIp(myIp);
        node.setVersionProtocolInfos(versionBody.getProtocolVersion(), versionBody.getBlockHeight(), versionBody.getBlockHash());
        node.setConnectStatus(5);
        node.setFailCount(0);
        node.setConnectTime(TimeManager.currentTimeMillis());
        if (node.isCrossConnect()) {
            node.getNodeGroup().getCrossNodeContainer().setLatestHandshakeSuccTime(TimeManager.currentTimeMillis());
        } else {
            node.getNodeGroup().getLocalNetNodeContainer().setLatestHandshakeSuccTime(TimeManager.currentTimeMillis());
        }
        VerackMessage verackMessage = MessageFactory.getInstance().buildVerackMessage(node, message.getHeader().getMagicNumber(), VerackMessageBody.VER_SUCCESS);
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("rec node={} ver msg success.go response verackMessage..cross={}", new Object[]{node.getId(), node.isCrossConnect()});
        MessageManager.getInstance().sendHandlerMsg(verackMessage, node, true);
        if (node.isSeedNode()) {
            MessageManager.getInstance().sendGetAddressMessage(node, false, false, true);
        }
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        int chainId = NodeGroupManager.getInstance().getChainIdByMagicNum(message.getHeader().getMagicNumber());
        LoggerUtil.logger(chainId).debug("VersionMessageHandler recieve:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        if (1 == node.getType()) {
            this.serverRecieveHandler(message, node);
        } else {
            this.clientRecieveHandler(message, node);
        }
        return NetworkEventResult.getResultSuccess();
    }

    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        int chainId = NodeGroupManager.getInstance().getChainIdByMagicNum(message.getHeader().getMagicNumber());
        LoggerUtil.logger(chainId).info("VersionMessageHandler send:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        VersionMessage versionMessage = (VersionMessage)message;
        if (node.isCrossConnect()) {
            ((VersionMessageBody)((Object)versionMessage.getMsgBody())).setBlockHash("");
            ((VersionMessageBody)((Object)versionMessage.getMsgBody())).setBlockHeight(0L);
        } else {
            BlockRpcService blockRpcService = (BlockRpcService)SpringLiteContext.getBean(BlockRpcServiceImpl.class);
            BestBlockInfo bestBlockInfo = blockRpcService.getBestBlockHeader(chainId);
            ((VersionMessageBody)((Object)versionMessage.getMsgBody())).setBlockHash(bestBlockInfo.getHash());
            ((VersionMessageBody)((Object)versionMessage.getMsgBody())).setBlockHeight(bestBlockInfo.getBlockHeight());
        }
        return super.send(message, node, asyn);
    }
}

