/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.message.body;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.network.model.dto.IpAddress;
import java.io.IOException;

public class VersionMessageBody
extends BaseNulsData {
    private long protocolVersion;
    private IpAddress addrYou = new IpAddress();
    private IpAddress addrMe = new IpAddress();
    private long blockHeight;
    private String blockHash = "";
    private String extend = "";

    public int size() {
        int s = 0;
        s += SerializeUtils.sizeOfUint32();
        s += this.addrYou.size();
        s += this.addrMe.size();
        s += SerializeUtils.sizeOfUint32();
        s += SerializeUtils.sizeOfString((String)this.blockHash);
        return s += SerializeUtils.sizeOfString((String)this.extend);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.protocolVersion);
        this.addrYou.serializeToStream(stream);
        this.addrMe.serializeToStream(stream);
        stream.writeUint32(this.blockHeight);
        stream.writeString(this.blockHash);
        stream.writeString(this.extend);
    }

    public void parse(NulsByteBuffer buffer) throws NulsException {
        try {
            this.protocolVersion = buffer.readUint32();
            this.addrYou.parse(buffer);
            this.addrMe.parse(buffer);
            this.blockHeight = buffer.readUint32();
            this.blockHash = buffer.readString();
            this.extend = buffer.readString();
            if (!buffer.isFinished()) {
                buffer.readByte();
            }
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public long getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(long protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public IpAddress getAddrYou() {
        return this.addrYou;
    }

    public void setAddrYou(IpAddress addrYou) {
        this.addrYou = addrYou;
    }

    public IpAddress getAddrMe() {
        return this.addrMe;
    }

    public void setAddrMe(IpAddress addrMe) {
        this.addrMe = addrMe;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }
}

