/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.netty.container;

import io.nuls.network.model.Node;
import io.nuls.network.model.po.NodePo;
import io.nuls.network.model.po.NodesContainerPo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NodesContainer
implements Serializable {
    private Map<String, Node> canConnectNodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Node> connectedNodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Node> disconnectNodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Node> failNodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Node> uncheckNodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Integer> inNodes = new ConcurrentHashMap<String, Integer>();
    private volatile long latestHandshakeSuccTime = 0L;
    private volatile boolean hadShareAddr = false;
    private volatile int status = 1;

    public int getConnectPeerNum() {
        return this.connectedNodes.size();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getLatestHandshakeSuccTime() {
        return this.latestHandshakeSuccTime;
    }

    public void setLatestHandshakeSuccTime(long latestHandshakeSuccTime) {
        this.latestHandshakeSuccTime = latestHandshakeSuccTime;
    }

    public boolean isHadShareAddr() {
        return this.hadShareAddr;
    }

    public void setHadShareAddr(boolean hadShareAddr) {
        this.hadShareAddr = hadShareAddr;
    }

    public NodesContainerPo parseToNodesContainerPo() {
        NodesContainerPo containerPo = new NodesContainerPo();
        for (Node node : this.disconnectNodes.values()) {
            if (node.getType() != 2) continue;
            containerPo.getDisConnectNodes().add((NodePo)node.parseToPo());
        }
        for (Node node : this.canConnectNodes.values()) {
            if (node.getType() != 2) continue;
            containerPo.getCanConnectNodes().add((NodePo)node.parseToPo());
        }
        for (Node node : this.failNodes.values()) {
            if (node.getType() != 2) continue;
            containerPo.getFailNodes().add((NodePo)node.parseToPo());
        }
        for (Node node : this.uncheckNodes.values()) {
            if (node.getType() != 2) continue;
            containerPo.getUncheckNodes().add((NodePo)node.parseToPo());
        }
        for (Node node : this.connectedNodes.values()) {
            if (node.getType() != 2) continue;
            containerPo.getCanConnectNodes().add((NodePo)node.parseToPo());
        }
        return containerPo;
    }

    public Map<String, Node> getAllCanShareNodes() {
        HashMap<String, Node> allNode = new HashMap<String, Node>();
        allNode.putAll(this.connectedNodes);
        allNode.putAll(this.canConnectNodes);
        return allNode;
    }

    public List<Node> getAvailableNodes() {
        Collection<Node> nodes = this.connectedNodes.values();
        ArrayList<Node> availableNodes = new ArrayList<Node>();
        if (null != nodes && nodes.size() > 0) {
            for (Node node : nodes) {
                if (5 != node.getConnectStatus()) continue;
                availableNodes.add(node);
            }
        }
        return availableNodes;
    }

    public boolean markCanuseNodeByIp(String ip, int type) {
        if (type == 1) {
            this.inNodes.put(ip, 1);
        } else {
            this.inNodes.remove(ip);
        }
        return this.markCanuseNodeByIp(ip, type, this.canConnectNodes);
    }

    public List<Node> getConnectedSeedNodes() {
        ArrayList<Node> connectedSeedNodes = new ArrayList<Node>();
        Collection<Node> nodes = this.connectedNodes.values();
        for (Node node : nodes) {
            if (!node.isSeedNode()) continue;
            connectedSeedNodes.add(node);
        }
        return connectedSeedNodes;
    }

    public boolean markCanuseNodeByIp(String ip, int type, Map<String, Node> nodes) {
        if (ip == null) {
            return false;
        }
        for (Node node : nodes.values()) {
            if (!ip.equals(node.getIp())) continue;
            node.setStatus(type);
            return true;
        }
        return false;
    }

    public boolean addNeedCheckNode(Node newNode) {
        String nodeId = newNode.getId();
        Node node = this.uncheckNodes.get(nodeId);
        if (node != null) {
            return false;
        }
        node = this.canConnectNodes.get(nodeId);
        if (node != null) {
            return false;
        }
        node = this.connectedNodes.get(nodeId);
        if (node != null) {
            return false;
        }
        node = this.disconnectNodes.get(nodeId);
        if (node != null) {
            return false;
        }
        node = this.failNodes.get(nodeId);
        if (node != null) {
            return false;
        }
        newNode.setLastProbeTime(0L);
        this.uncheckNodes.put(nodeId, newNode);
        newNode.setStatus(0);
        return true;
    }

    public int getConnectedCount(int type) {
        int size = 0;
        for (Node node : this.connectedNodes.values()) {
            if (node.getType() != type) continue;
            ++size;
        }
        return size;
    }

    public void clear() {
        this.uncheckNodes.clear();
        this.canConnectNodes.clear();
        this.disconnectNodes.clear();
        this.failNodes.clear();
        this.connectedNodes.clear();
    }

    public boolean hadInConnection(String ip) {
        return null != this.inNodes.get(ip);
    }

    public Node getNode(String nodeId) {
        return this.connectedNodes.get(nodeId);
    }

    public Map<String, Node> getCanConnectNodes() {
        return this.canConnectNodes;
    }

    public void setCanConnectNodes(Map<String, Node> canConnectNodes) {
        this.canConnectNodes = canConnectNodes;
    }

    public Map<String, Node> getConnectedNodes() {
        return this.connectedNodes;
    }

    public void setConnectedNodes(Map<String, Node> connectedNodes) {
        this.connectedNodes = connectedNodes;
    }

    public Map<String, Node> getDisconnectNodes() {
        return this.disconnectNodes;
    }

    public void setDisconnectNodes(Map<String, Node> disconnectNodes) {
        this.disconnectNodes = disconnectNodes;
    }

    public Map<String, Node> getFailNodes() {
        return this.failNodes;
    }

    public void setFailNodes(Map<String, Node> failNodes) {
        this.failNodes = failNodes;
    }

    public Map<String, Node> getUncheckNodes() {
        return this.uncheckNodes;
    }

    public void setUncheckNodes(Map<String, Node> uncheckNodes) {
        this.uncheckNodes = uncheckNodes;
    }
}

