/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.network.manager.ConnectionManager;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.handler.base.BaseChannelHandler;
import io.nuls.network.model.Node;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;
import java.io.IOException;

@ChannelHandler.Sharable
public class ServerChannelHandler
extends BaseChannelHandler {
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        SocketChannel socketChannel = (SocketChannel)ctx.channel();
        boolean success = ConnectionManager.getInstance().nodeConnectIn(socketChannel.remoteAddress().getHostString(), socketChannel.remoteAddress().getPort(), socketChannel);
        if (!success) {
            ctx.close();
            return;
        }
        ctx.channel().config().setWriteBufferHighWaterMark(0x800000);
        ctx.channel().config().setWriteBufferLowWaterMark(0x400000);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        SocketChannel channel = (SocketChannel)ctx.channel();
        String nodeId = IpUtil.getNodeId(channel.remoteAddress());
        LoggerUtil.COMMON_LOG.info("Server Node is Inactive:{}", new Object[]{nodeId});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        SocketChannel channel = (SocketChannel)ctx.channel();
        String remoteIP = channel.remoteAddress().getHostString();
        LoggerUtil.COMMON_LOG.error("Server Node is exceptionCaught:{}:{}", new Object[]{remoteIP, channel.remoteAddress().getPort()});
        LoggerUtil.COMMON_LOG.error(cause);
        if (!(cause instanceof IOException)) {
            String nodeId = IpUtil.getNodeId(channel.remoteAddress());
            LoggerUtil.COMMON_LOG.error("-----------exceptionCaught-----nodeId:{}", new Object[]{nodeId});
            LoggerUtil.COMMON_LOG.error(cause);
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        SocketChannel channel = (SocketChannel)ctx.channel();
        ByteBuf buf = (ByteBuf)msg;
        String remoteIP = channel.remoteAddress().getHostString();
        NulsByteBuffer byteBuffer = null;
        Node node = null;
        try {
            String nodeId = IpUtil.getNodeId(channel.remoteAddress());
            Attribute nodeAttribute = channel.attr(AttributeKey.valueOf((String)("node-" + nodeId)));
            node = (Node)nodeAttribute.get();
            if (node != null) {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                byteBuffer = new NulsByteBuffer(bytes);
            } else {
                LoggerUtil.COMMON_LOG.error("-----------------Server channelRead  node is null -----------------" + remoteIP + ":" + channel.remoteAddress().getPort());
                ctx.channel().close();
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
        finally {
            buf.clear();
        }
        MessageManager.getInstance().receiveMessage(byteBuffer, node);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        SocketChannel channel = (SocketChannel)ctx.channel();
        String nodeId = IpUtil.getNodeId(channel.remoteAddress());
        Attribute nodeAttribute = channel.attr(AttributeKey.valueOf((String)("node-" + nodeId)));
        Node node = (Node)nodeAttribute.get();
        if (node != null && node.getDisconnectListener() != null) {
            node.getDisconnectListener().action();
        }
        LoggerUtil.COMMON_LOG.info("Server Node is channelUnregistered:{}:{}", new Object[]{channel.remoteAddress().getHostString(), channel.remoteAddress().getPort()});
    }
}

