/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.rpc.cmd;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.network.constant.NetworkErrorCode;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.StorageManager;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.po.GroupPo;
import io.nuls.network.model.vo.NodeGroupVo;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.NW)
public class NodeGroupRpc
extends BaseCmd {
    @Autowired
    NulsCoresConfig networkConfig;

    @CmdAnnotation(cmd="nw_createNodeGroup", version=1.0, description="Create a cross chain network for the main network or a chain factory to create a chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="magicNumber", requestType=@TypeDescriptor(value=long.class), parameterDes="Network Magic Parameters"), @Parameter(parameterName="maxOut", requestType=@TypeDescriptor(value=int.class), parameterDes="As aclientMaximum number of active external connections"), @Parameter(parameterName="maxIn", requestType=@TypeDescriptor(value=int.class), parameterDes="As aseverAllow maximum number of external connections"), @Parameter(parameterName="minAvailableCount", requestType=@TypeDescriptor(value=int.class), parameterDes="Minimum effective number of connections"), @Parameter(parameterName="isCrossGroup", requestType=@TypeDescriptor(value=boolean.class), parameterDes="Do you want to create a cross chain connection group:true Cross chain connection,false Normal connection")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response createNodeGroup(Map params) {
        ArrayList<GroupPo> nodeGroupPos = new ArrayList<GroupPo>();
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        long magicNumber = Long.valueOf(String.valueOf(params.get("magicNumber")));
        int maxOut = 0;
        if (StringUtils.isNotBlank((String)String.valueOf(params.get("maxOut")))) {
            maxOut = Integer.valueOf(String.valueOf(params.get("maxOut")));
        }
        if (maxOut == 0) {
            maxOut = this.networkConfig.isMoonNode() ? this.networkConfig.getCrossMaxOutCount() : this.networkConfig.getMaxOutCount();
        }
        int maxIn = 0;
        if (StringUtils.isNotBlank((String)String.valueOf(params.get("maxIn")))) {
            maxIn = Integer.valueOf(String.valueOf(params.get("maxIn")));
        }
        if (maxIn == 0) {
            maxIn = this.networkConfig.isMoonNode() ? this.networkConfig.getCrossMaxInCount() : this.networkConfig.getMaxInCount();
        }
        int minAvailableCount = Integer.valueOf(String.valueOf(params.get("minAvailableCount")));
        boolean isCrossGroup = Boolean.valueOf(params.get("isCrossGroup").toString());
        if (!this.networkConfig.isMoonNode() && isCrossGroup) {
            LoggerUtil.logger(chainId).error("Local is not Moon net,can not create CrossGroup");
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        NodeGroup nodeGroup = nodeGroupManager.getNodeGroupByMagic(magicNumber);
        if (null != nodeGroup) {
            LoggerUtil.logger(chainId).error("getNodeGroupByMagic: nodeGroup  exist");
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        nodeGroup = new NodeGroup(magicNumber, chainId, maxIn, maxOut, minAvailableCount);
        nodeGroupPos.add((GroupPo)nodeGroup.parseToPo());
        StorageManager.getInstance().getDbService().saveNodeGroups(nodeGroupPos);
        nodeGroupManager.addNodeGroup(nodeGroup.getChainId(), nodeGroup);
        if (this.networkConfig.isMoonNode()) {
            MessageManager.getInstance().sendGetCrossAddressMessage(nodeGroupManager.getMoonMainNet(), nodeGroup, false, true, true);
        } else {
            MessageManager.getInstance().sendGetCrossAddressMessage(nodeGroup, nodeGroup, false, true, true);
        }
        return this.success();
    }

    @CmdAnnotation(cmd="nw_activeCross", version=1.0, description="Cross chain protocol module activation cross chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="maxOut", requestType=@TypeDescriptor(value=String.class), parameterDes="As aclientMaximum number of active external connections"), @Parameter(parameterName="maxIn", requestType=@TypeDescriptor(value=int.class), parameterDes="As aseverAllow maximum number of external connections"), @Parameter(parameterName="seedIps", requestType=@TypeDescriptor(value=String.class), parameterDes="Seed Connection NodeID,Splicing with commas")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response activeCross(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        LoggerUtil.logger(chainId).info("params:chainId={},maxOut={},maxIn={},seedIps={}", new Object[]{params.get("chainId"), params.get("maxOut"), params.get("maxIn"), params.get("seedIps")});
        ArrayList nodeGroupPos = new ArrayList();
        int maxOut = null == params.get("maxOut") || 0 == Integer.valueOf(params.get("maxOut").toString()) ? this.networkConfig.getMaxOutCount() : Integer.valueOf(String.valueOf(params.get("maxOut"))).intValue();
        int maxIn = null == params.get("maxIn") || 0 == Integer.valueOf(params.get("maxIn").toString()) ? this.networkConfig.getMaxInCount() : Integer.valueOf(String.valueOf(params.get("maxIn"))).intValue();
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        String seedIps = String.valueOf(params.get("seedIps"));
        LoggerUtil.logger(chainId).info("chainId={},seedIps={}", new Object[]{chainId, seedIps});
        NodeGroup nodeGroup = nodeGroupManager.getNodeGroupByChainId(chainId);
        if (null == nodeGroup) {
            LoggerUtil.logger(chainId).error("getNodeGroupByMagic is null");
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        if (chainId != nodeGroup.getChainId()) {
            LoggerUtil.logger(chainId).error("chainId != nodeGroup.getChainId()");
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        nodeGroup.setMaxCrossIn(maxIn);
        nodeGroup.setMaxCrossOut(maxOut);
        ArrayList ipList = new ArrayList();
        if (StringUtils.isNotBlank((String)seedIps)) {
            String[] ips = seedIps.split(",");
            Collections.addAll(ipList, ips);
        }
        for (String croosSeed : ipList) {
            String[] crossAddr = croosSeed.split(":");
            nodeGroup.addNeedCheckNode(crossAddr[0], Integer.valueOf(crossAddr[1]), Integer.valueOf(crossAddr[1]), true);
        }
        nodeGroup.setCrossActive(true);
        return this.success();
    }

    @CmdAnnotation(cmd="nw_getGroupByChainId", version=1.0, description="Get node group information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]")})
    @ResponseData(description="Return node group information", responseType=@TypeDescriptor(value=NodeGroupVo.class))
    public Response getGroupByChainId(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
        NodeGroupVo nodeGroupVo = this.buildNodeGroupVo(nodeGroup);
        return this.success(nodeGroupVo);
    }

    private NodeGroupVo buildNodeGroupVo(NodeGroup nodeGroup) {
        NodeGroupVo nodeGroupVo = new NodeGroupVo();
        nodeGroupVo.setChainId(nodeGroup.getChainId());
        nodeGroupVo.setMagicNumber(nodeGroup.getMagicNumber());
        nodeGroupVo.setConnectCount(nodeGroup.getLocalNetNodeContainer().getConnectedNodes().size());
        nodeGroupVo.setDisConnectCount(nodeGroup.getLocalNetNodeContainer().getCanConnectNodes().size() + nodeGroup.getLocalNetNodeContainer().getDisconnectNodes().size() + nodeGroup.getLocalNetNodeContainer().getUncheckNodes().size() + nodeGroup.getLocalNetNodeContainer().getFailNodes().size());
        nodeGroupVo.setConnectCrossCount(nodeGroup.getCrossNodeContainer().getConnectedNodes().size());
        nodeGroupVo.setDisConnectCrossCount(nodeGroup.getCrossNodeContainer().getCanConnectNodes().size() + nodeGroup.getCrossNodeContainer().getDisconnectNodes().size() + nodeGroup.getCrossNodeContainer().getUncheckNodes().size());
        nodeGroupVo.setInCount(nodeGroup.getLocalNetNodeContainer().getConnectedCount(1));
        nodeGroupVo.setOutCount(nodeGroup.getLocalNetNodeContainer().getConnectedCount(2));
        nodeGroupVo.setInCrossCount(nodeGroup.getCrossNodeContainer().getConnectedCount(1));
        nodeGroupVo.setOutCrossCount(nodeGroup.getCrossNodeContainer().getConnectedCount(2));
        if (nodeGroup.isMoonCrossGroup()) {
            nodeGroupVo.setIsActive(nodeGroup.isActive(true) ? 1 : 0);
        } else {
            nodeGroupVo.setIsActive(nodeGroup.isActive(false) ? 1 : 0);
        }
        nodeGroupVo.setIsCrossActive(nodeGroup.isCrossActive() ? 1 : 0);
        nodeGroupVo.setIsMoonNet(nodeGroup.isMoonGroup() ? 1 : 0);
        nodeGroupVo.setTotalCount(nodeGroupVo.getInCount() + nodeGroupVo.getOutCount() + nodeGroupVo.getInCrossCount() + nodeGroupVo.getOutCrossCount());
        return nodeGroupVo;
    }

    @CmdAnnotation(cmd="nw_getChainConnectAmount", version=1.0, description="Get the specified number of network group connections")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="isCross", requestType=@TypeDescriptor(value=boolean.class), parameterDes="trueObtain the number of cross chain connections,falseNumber of local network connections")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="connectAmount", valueType=Integer.class, description="Number of connections available")}))
    public Response getChainConnectAmount(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        try {
            NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
            HashMap<String, Integer> rtMap = new HashMap<String, Integer>();
            if (null == nodeGroup) {
                rtMap.put("connectAmount", 0);
            } else {
                boolean isCross = Boolean.valueOf(String.valueOf(params.get("isCross")));
                rtMap.put("connectAmount", nodeGroup.getAvailableNodes(isCross).size());
            }
            return this.success(rtMap);
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="nw_delNodeGroup", version=1.0, description="Delete specified network group")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response delGroupByChainId(Map params) {
        int chainId = Integer.parseInt(String.valueOf(params.get("chainId")));
        StorageManager.getInstance().getDbService().deleteGroup(chainId);
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
        nodeGroup.destroy();
        return this.success();
    }

    @CmdAnnotation(cmd="nw_getSeeds", version=1.0, description="View seed nodes provided by cross chain networks")
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="seedsIps", valueType=String.class, description="Seed nodes that can be connected to the main networkIDSplicing with commas")}))
    public Response getCrossSeeds(Map params) {
        List<String> seeds = this.networkConfig.getMoonSeedIpList();
        if (null == seeds) {
            return this.success();
        }
        StringBuilder seedsStr = new StringBuilder();
        for (String seed : seeds) {
            seedsStr.append(seed);
            seedsStr.append(",");
        }
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        if (seedsStr.length() > 0) {
            rtMap.put("seedsIps", seedsStr.substring(0, seedsStr.length() - 1));
        } else {
            rtMap.put("seedsIps", "");
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="nw_getMainMagicNumber", version=1.0, description="View the magic parameters of the main network")
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="value", valueType=Long.class, description="Main network magic parameters")}))
    public Response getMainMagicNumber(Map params) {
        try {
            HashMap<String, Long> rtMap = new HashMap<String, Long>();
            rtMap.put("value", this.networkConfig.getPacketMagic());
            return this.success(rtMap);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return this.failed(NetworkErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="nw_reconnect", version=1.0, description="Local network restart")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Networking ChainId,Value range[1-65535]")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response reconnect(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
        nodeGroup.reconnect(false);
        return this.success();
    }

    @CmdAnnotation(cmd="nw_getGroups", version=1.0, description="Paging to obtain network group information,startPageRelated topageSize All for0When not paginated, returns all network group information")
    @Parameters(value={@Parameter(parameterName="startPage", requestType=@TypeDescriptor(value=int.class), parameterDes="Start Page"), @Parameter(parameterName="pageSize", requestType=@TypeDescriptor(value=int.class), parameterDes="Display quantity per page")})
    @ResponseData(name="Return value", description="Return aPageObject, only described herePageCollection in objects", responseType=@TypeDescriptor(value=List.class, collectionElement=NodeGroupVo.class))
    public Response getGroups(Map params) {
        int startPage = Integer.valueOf(String.valueOf(params.get("startPage")));
        int pageSize = Integer.valueOf(String.valueOf(params.get("pageSize")));
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        List<NodeGroup> nodeGroups = nodeGroupManager.getNodeGroups();
        int total = nodeGroups.size();
        ArrayList<NodeGroupVo> pageList = new ArrayList<NodeGroupVo>();
        if (startPage == 0 && pageSize == 0) {
            for (NodeGroup nodeGroup : nodeGroups) {
                pageList.add(this.buildNodeGroupVo(nodeGroup));
            }
        } else {
            int currIdx = startPage > 1 ? (startPage - 1) * pageSize : 0;
            for (int i = 0; i < pageSize && i < total - currIdx; ++i) {
                NodeGroup nodeGroup = nodeGroups.get(currIdx + i);
                NodeGroupVo nodeGroupVo = this.buildNodeGroupVo(nodeGroup);
                pageList.add(nodeGroupVo);
            }
        }
        return this.success(pageList);
    }
}

