/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.network.manager.TimeManager;
import io.nuls.network.utils.LoggerUtil;

public class TimeTask
implements Runnable {
    TimeManager timeManager = TimeManager.getInstance();

    @Override
    public void run() {
        long lastTime = System.currentTimeMillis();
        this.timeManager.syncWebTime();
        while (true) {
            long newTime;
            if (Math.abs((newTime = System.currentTimeMillis()) - lastTime) > 3000L) {
                LoggerUtil.COMMON_LOG.debug("local time changed \uff1a{}", new Object[]{newTime - lastTime});
                this.timeManager.syncWebTime();
            } else if (TimeManager.currentTimeMillis() - TimeManager.lastSyncTime > 120000L) {
                this.timeManager.syncWebTime();
            }
            lastTime = newTime;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

