/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.utils;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.network.utils.LoggerUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpUtil {
    private static final Pattern pattern = Pattern.compile("\\<dd class\\=\"fz24\">(.*?)\\<\\/dd>");
    private static final Set<String> ips = new HashSet<String>();

    public static boolean isSelf(String ip) {
        NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
        return ips.contains(ip) || networkConfig.getLocalIps().contains(ip);
    }

    public static Set<String> getIps() {
        return ips;
    }

    public static String getHostIp(String nodeId) {
        String[] hostAndPort = IpUtil.splitHostPort(nodeId);
        String addr = hostAndPort[0];
        try {
            String hostIp = InetAddress.getByName(addr).getHostAddress();
            return hostIp;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return nodeId;
        }
    }

    public static String[] changeHostToIp(String hostPort) {
        String[] hostAndPort = IpUtil.splitHostPort(hostPort);
        String addr = hostAndPort[0];
        try {
            String hostIp;
            hostAndPort[0] = hostIp = InetAddress.getByName(addr).getHostAddress();
        }
        catch (UnknownHostException e) {
            LoggerUtil.COMMON_LOG.error((Exception)e);
            return null;
        }
        return hostAndPort;
    }

    public static String changeHostToIpStr(String hostPort) {
        String[] hostAndPort = IpUtil.splitHostPort(hostPort);
        String addr = hostAndPort[0];
        try {
            String hostIp = InetAddress.getByName(addr).getHostAddress();
            return hostIp + ":" + hostAndPort[1];
        }
        catch (UnknownHostException e) {
            LoggerUtil.COMMON_LOG.error((Exception)e);
            return null;
        }
    }

    public static String[] splitHostPort(String ipPort) {
        String[] hostPort = new String[]{"", ""};
        int lastSplitIndex = ipPort.lastIndexOf(":");
        if (-1 == lastSplitIndex) {
            hostPort[0] = ipPort;
            hostPort[1] = "80";
        } else {
            hostPort[0] = ipPort.substring(0, lastSplitIndex);
            hostPort[1] = ipPort.substring(lastSplitIndex + 1, ipPort.length());
        }
        return hostPort;
    }

    private static ArrayList<String> getLocalIP() {
        ArrayList<String> iplist = new ArrayList<String>();
        boolean loop = false;
        ArrayList<NetworkInterface> netlist = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> network = NetworkInterface.getNetworkInterfaces();
            block4: while (network.hasMoreElements()) {
                loop = true;
                NetworkInterface ni = network.nextElement();
                if (ni.isLoopback()) continue;
                netlist.add(0, ni);
                for (NetworkInterface list : netlist) {
                    if (!loop) continue block4;
                    Enumeration<InetAddress> card = list.getInetAddresses();
                    block6: while (card.hasMoreElements()) {
                        InetAddress ip;
                        do {
                            ip = null;
                            try {
                                ip = card.nextElement();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (ip == null) continue block6;
                        } while (!ip.isLoopbackAddress() && "127.0.0.1".equalsIgnoreCase(ip.getHostAddress()) || ip instanceof Inet6Address || !(ip instanceof Inet4Address));
                        String bindip = ip.getHostAddress();
                        boolean addto = true;
                        for (int n = 0; n < iplist.size(); ++n) {
                            if (!bindip.equals(iplist.get(n))) continue;
                            addto = false;
                            break;
                        }
                        if (!addto) continue;
                        iplist.add(bindip);
                    }
                }
            }
        }
        catch (SocketException e) {
            Log.error((String)("Get local IP error: " + e.getMessage()));
        }
        return iplist;
    }

    public static boolean judgeLocalIsServer(String localIP, String remoteIP) {
        long remote;
        long local = IpUtil.ipToLong(localIP);
        return local < (remote = IpUtil.ipToLong(remoteIP));
    }

    public static long ipToLong(String ipAddress) {
        long result = 0L;
        String[] ipAddressInArray = ipAddress.split("\\.");
        for (int i = 3; i >= 0; --i) {
            long ip = Long.parseLong(ipAddressInArray[3 - i]);
            result |= ip << i * 8;
        }
        return result;
    }

    public static String getNodeId(InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        return socketAddress.getHostString() + ":" + socketAddress.getPort();
    }

    public static boolean isboolIp(String ipAddress) {
        String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pattern = Pattern.compile(ip);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    static {
        ArrayList<String> localIPs = IpUtil.getLocalIP();
        for (String ip : localIPs) {
            ips.add(ip);
        }
    }
}

