/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.protocol.manager.ContextManager;
import io.nuls.protocol.model.po.StatisticsInfo;
import io.nuls.protocol.storage.StatisticsStorageService;
import java.util.ArrayList;
import java.util.List;

@Component
public class StatisticsStorageServiceImpl
implements StatisticsStorageService {
    @Override
    public boolean save(int chainId, StatisticsInfo statisticsInfo) {
        try {
            byte[] bytes = statisticsInfo.serialize();
            return RocksDBService.put((String)("statistics_info_" + chainId), (byte[])ByteUtils.longToBytes((long)statisticsInfo.getHeight()), (byte[])bytes);
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return false;
        }
    }

    @Override
    public StatisticsInfo get(int chainId, long height) {
        try {
            StatisticsInfo po = new StatisticsInfo();
            byte[] bytes = RocksDBService.get((String)("statistics_info_" + chainId), (byte[])ByteUtils.longToBytes((long)height));
            po.parse(new NulsByteBuffer(bytes));
            return po;
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return null;
        }
    }

    @Override
    public boolean delete(int chainId, long height) {
        try {
            return RocksDBService.delete((String)("statistics_info_" + chainId), (byte[])ByteUtils.longToBytes((long)height));
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return false;
        }
    }

    @Override
    public List<StatisticsInfo> getList(int chainId) {
        try {
            ArrayList<StatisticsInfo> pos = new ArrayList<StatisticsInfo>();
            List valueList = RocksDBService.valueList((String)("statistics_info_" + chainId));
            for (byte[] bytes : valueList) {
                StatisticsInfo po = new StatisticsInfo();
                po.parse(new NulsByteBuffer(bytes));
                pos.add(po);
            }
            return pos;
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return null;
        }
    }
}

