/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.message.BroadcastTxMessage;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxDuplicateRemoval;

@Component(value="BroadcastTxMessageHandlerV1")
public class BroadcastTxMessageHandler
implements MessageProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxService txService;

    public String getCmd() {
        return "receiveTx";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        Chain chain = null;
        try {
            chain = this.chainManager.getChain(chainId);
            if (!chain.getProcessTxStatus().get()) {
                return;
            }
            BroadcastTxMessage message = (BroadcastTxMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, BroadcastTxMessage.class));
            if (message == null) {
                return;
            }
            Transaction transaction = message.getTx();
            String hash = transaction.getHash().toHex();
            boolean rs = TxDuplicateRemoval.insertAndCheck(hash);
            TxDuplicateRemoval.putExcludeNode(hash, nodeId);
            if (!rs) {
                return;
            }
            this.txService.newBroadcastTx(this.chainManager.getChain(chainId), new TransactionNetPO(transaction, nodeId));
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

