/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.NulsData;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class TransactionConfirmedPO
extends BaseNulsData {
    private Transaction tx;
    private long blockHeight = -1L;
    private byte status = TxStatusEnum.UNCONFIRM.getStatus();

    public TransactionConfirmedPO() {
    }

    public TransactionConfirmedPO(Transaction tx, long blockHeight, byte status) {
        this.tx = tx;
        this.blockHeight = blockHeight;
        this.status = status;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeNulsData((BaseNulsData)this.tx);
        stream.writeUint32(this.blockHeight);
        stream.write((int)this.status);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.tx = byteBuffer.readTransaction();
        this.blockHeight = byteBuffer.readUint32();
        this.status = byteBuffer.readByte();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfNulsData((NulsData)this.tx);
        size += SerializeUtils.sizeOfUint32();
        return ++size;
    }

    public Transaction getTx() {
        return this.tx;
    }

    public void setTx(Transaction tx) {
        this.tx = tx;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }
}

