/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.task;

import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.po.TransactionUnconfirmedPO;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ClearUnconfirmedTxProcessTask
implements Runnable {
    private PackablePool packablePool = (PackablePool)SpringLiteContext.getBean(PackablePool.class);
    private TxService txService = (TxService)SpringLiteContext.getBean(TxService.class);
    private UnconfirmedTxStorageService unconfirmedTxStorageService = (UnconfirmedTxStorageService)SpringLiteContext.getBean(UnconfirmedTxStorageService.class);
    private NulsCoresConfig txConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
    private Chain chain;

    public ClearUnconfirmedTxProcessTask(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void run() {
        try {
            this.doTask(this.chain);
        }
        catch (Exception e) {
            this.chain.getLogger().error(e);
        }
    }

    private void doTask(Chain chain) {
        List<byte[]> txKeyList = this.unconfirmedTxStorageService.getAllTxkeyList(chain.getChainId());
        if (txKeyList == null || txKeyList.size() == 0) {
            return;
        }
        int count = this.processUnconfirmedTxs(txKeyList);
        chain.getLogger().info("[UnconfirmedTxProcessTask] Clean expire count: {}", new Object[]{count});
    }

    private boolean processTx(Chain chain, Transaction tx) {
        try {
            this.txService.clearInvalidTx(chain, tx, false);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
        return false;
    }

    private int processUnconfirmedTxs(List<byte[]> txKeyList) {
        int unconfirmedTxsCount = 0;
        ArrayList<byte[]> queryList = new ArrayList<byte[]>();
        for (int i = 0; i < txKeyList.size(); ++i) {
            queryList.add(txKeyList.get(i));
            if (queryList.size() != 10000) continue;
            unconfirmedTxsCount += this.processExpireTxs(queryList);
            queryList.clear();
        }
        if (!queryList.isEmpty()) {
            unconfirmedTxsCount += this.processExpireTxs(queryList);
        }
        return unconfirmedTxsCount;
    }

    public int processExpireTxs(List<byte[]> queryList) {
        List<TransactionUnconfirmedPO> list = this.unconfirmedTxStorageService.getTransactionUnconfirmedPOList(this.chain.getChainId(), queryList);
        List<Transaction> expireTxList = this.getExpireTxList(list);
        int count = 0;
        for (int i = 0; i < expireTxList.size(); ++i) {
            Transaction tx = expireTxList.get(i);
            if (this.packablePool.exist(this.chain, tx)) continue;
            this.processTx(this.chain, tx);
            ++count;
        }
        return count;
    }

    private List<Transaction> getExpireTxList(List<TransactionUnconfirmedPO> txPOList) {
        ArrayList<Transaction> expireTxList = new ArrayList<Transaction>();
        long currentTimeSeconds = NulsDateUtils.getCurrentTimeSeconds();
        List<TransactionUnconfirmedPO> expireTxPOList = txPOList.stream().filter(txPo -> currentTimeSeconds - this.txConfig.getUnconfirmedTxExpire() > txPo.getCreateTime()).collect(Collectors.toList());
        expireTxPOList.forEach(txPo -> expireTxList.add(txPo.getTx()));
        return expireTxList;
    }
}

