/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.task;

import io.nuls.base.data.Transaction;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.TxManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.TxRegister;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.rpc.call.LedgerCall;
import io.nuls.transaction.rpc.call.NetworkCall;
import io.nuls.transaction.rpc.call.TransactionCall;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import io.nuls.transaction.utils.TxDuplicateRemoval;
import io.nuls.transaction.utils.TxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NetTxProcessTask
implements Runnable {
    private PackablePool packablePool = (PackablePool)SpringLiteContext.getBean(PackablePool.class);
    private UnconfirmedTxStorageService unconfirmedTxStorageService = (UnconfirmedTxStorageService)SpringLiteContext.getBean(UnconfirmedTxStorageService.class);
    private TxService txService = (TxService)SpringLiteContext.getBean(TxService.class);
    private Chain chain;

    public NetTxProcessTask(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            this.chain.getLogger().error("NetTxProcessTask Exception");
            this.chain.getLogger().error(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void process() {
        while (true) {
            try {
                block3: while (true) {
                    if (this.chain.getUnverifiedQueue().isEmpty()) {
                        Thread.sleep(3000L);
                        continue;
                    }
                    if (this.chain.getProtocolUpgrade().get()) {
                        this.chain.getLogger().info("Protocol upgrade pause process new tx..");
                        Thread.sleep(10000L);
                        continue;
                    }
                    txNetList = new ArrayList<TransactionNetPO>(3000);
                    this.chain.getUnverifiedQueue().drainTo(txNetList, 3000);
                    moduleVerifyMap = new HashMap<String, List<String>>(8);
                    it = txNetList.iterator();
                    packableTxMapDataSize = 0;
                    for (Transaction tx : this.chain.getPackableTxMap().values()) {
                        packableTxMapDataSize += tx.size();
                    }
                    while (it.hasNext()) {
                        txNetPO = (TransactionNetPO)it.next();
                        tx = txNetPO.getTx();
                        if (TxUtil.discardTx(this.chain, packableTxMapDataSize, tx)) {
                            hash = tx.getHash().toHex();
                            NetworkCall.broadcastTx(this.chain, tx, TxDuplicateRemoval.getExcludeNode(hash));
                            it.remove();
                            continue;
                        }
                        TxUtil.moduleGroups(this.chain, moduleVerifyMap, tx);
                    }
                    this.verifiction(this.chain, moduleVerifyMap, txNetList);
                    this.verifyCoinData(this.chain, txNetList);
                    if (txNetList.isEmpty()) continue;
                    this.unconfirmedTxStorageService.putTxList(this.chain.getChainId(), txNetList);
                    var5_6 = txNetList.iterator();
                    while (true) {
                        if (var5_6.hasNext()) ** break;
                        continue block3;
                        txNet = (TransactionNetPO)var5_6.next();
                        tx = txNet.getTx();
                        if (this.chain.getPackaging().get()) {
                            this.packablePool.add(this.chain, tx);
                        }
                        hash = tx.getHash().toHex();
                        NetworkCall.forwardTxHash(this.chain, tx.getHash(), TxDuplicateRemoval.getExcludeNode(hash));
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.chain.getLogger().error(e);
                continue;
            }
            break;
        }
    }

    private void verifiction(Chain chain, Map<String, List<String>> moduleVerifyMap, List<TransactionNetPO> txNetList) {
        for (Map.Entry<String, List<String>> entry : moduleVerifyMap.entrySet()) {
            List<String> moduleList = entry.getValue();
            String moduleCode = entry.getKey();
            List<String> txHashList = null;
            try {
                txHashList = TransactionCall.txModuleValidator(chain, moduleCode, moduleList);
            }
            catch (NulsException e) {
                chain.getLogger().error("Net new tx verify failed -txModuleValidator Exception:{}, module-code:{}, count:{} , return count:{}", new Object[]{"txValidator", moduleCode, moduleList.size(), txHashList.size()});
                Iterator<TransactionNetPO> its = txNetList.iterator();
                while (its.hasNext()) {
                    Transaction tx = its.next().getTx();
                    TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
                    if (!txRegister.getModuleCode().equals(moduleCode)) continue;
                    its.remove();
                }
                continue;
            }
            if (null == txHashList || txHashList.isEmpty()) continue;
            chain.getLogger().error("[Net new tx verify failed] module:{}, module-code:{}, count:{} , return count:{}", new Object[]{"txValidator", moduleCode, moduleList.size(), txHashList.size()});
            for (int i = 0; i < txHashList.size(); ++i) {
                String hash = txHashList.get(i);
                Iterator<TransactionNetPO> its = txNetList.iterator();
                while (its.hasNext()) {
                    Transaction tx = its.next().getTx();
                    if (!hash.equals(tx.getHash().toHex())) continue;
                    its.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCoinData(Chain chain, List<TransactionNetPO> txNetList) throws NulsException {
        if (txNetList.isEmpty()) {
            return;
        }
        try {
            Map verifyCoinDataResult = LedgerCall.commitBatchUnconfirmedTxs(chain, txNetList);
            List failHashs = (List)verifyCoinDataResult.get("fail");
            List orphanHashs = (List)verifyCoinDataResult.get("orphan");
            if (failHashs.isEmpty() && orphanHashs.isEmpty()) {
                return;
            }
            Iterator<TransactionNetPO> it = txNetList.iterator();
            block5: while (it.hasNext()) {
                String hashStr;
                TransactionNetPO transactionNetPO = it.next();
                Transaction tx = transactionNetPO.getTx();
                for (String hash : failHashs) {
                    if (!hash.equals(hashStr = tx.getHash().toHex())) continue;
                    it.remove();
                    continue block5;
                }
                for (String hash : orphanHashs) {
                    if (!hash.equals(hashStr = tx.getHash().toHex())) continue;
                    LinkedList<TransactionNetPO> chainOrphan = chain.getOrphanList();
                    if (chain.getOrphanListDataSize().get() >= 15000000) {
                        it.remove();
                        continue block5;
                    }
                    LinkedList<TransactionNetPO> linkedList = chainOrphan;
                    synchronized (linkedList) {
                        chainOrphan.add(transactionNetPO);
                        chain.getOrphanListDataSize().addAndGet(transactionNetPO.getTx().size());
                    }
                    it.remove();
                    continue block5;
                }
            }
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }
}

