/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.utils;

import java.util.HashSet;
import java.util.Set;

public class HashSetDuplicateProcessor {
    private final int maxSize;
    private final int percent90;
    private Set<String> set1 = new HashSet<String>();
    private Set<String> set2 = new HashSet<String>();

    public HashSetDuplicateProcessor(int maxSize) {
        this.maxSize = maxSize;
        this.percent90 = maxSize * 9 / 10;
    }

    public synchronized boolean insertAndCheck(String hash) {
        boolean result = this.set1.add(hash);
        if (!result) {
            return result;
        }
        int size = this.set1.size();
        if (size >= this.maxSize) {
            this.set2.add(hash);
            this.set1.clear();
            this.set1.addAll(this.set2);
            this.set2.clear();
        } else if (size >= this.percent90) {
            this.set2.add(hash);
        }
        return result;
    }

    public boolean contains(String hash) {
        return this.set1.contains(hash);
    }

    public void remove(String hash) {
        this.set1.remove(hash);
        this.set2.remove(hash);
    }
}

