/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.config;

import java.util.HashSet;
import java.util.Set;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.Repository;
import org.ethereum.crypto.HashUtil;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.AsyncWriteCache;
import org.ethereum.datasource.BatchSourceWriter;
import org.ethereum.datasource.DbSettings;
import org.ethereum.datasource.DbSource;
import org.ethereum.datasource.MemSizeEstimator;
import org.ethereum.datasource.PrefixLookupSource;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.WriteCache;
import org.ethereum.datasource.XorDataSource;
import org.ethereum.datasource.inmem.HashMapDB;
import org.ethereum.datasource.rocksdb.RocksDbDataSource;
import org.ethereum.db.DbFlushManager;
import org.ethereum.db.HeaderStore;
import org.ethereum.db.RepositoryRoot;
import org.ethereum.db.StateSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)"general");
    private Set<DbSource> dbSources = new HashSet<DbSource>();
    private int chainId;
    private Source<byte[], byte[]> trieNodeSource;
    private StateSource stateSource;
    private AbstractCachedSource<byte[], byte[]> blockchainDbCache;
    private DbSource<byte[]> headerSource;
    private HeaderStore headerStore;
    private DbSource<byte[]> blockchainDB;
    private DbFlushManager dbFlushManager;

    public static CommonConfig newInstance(int chainId) {
        CommonConfig commonConfig = new CommonConfig();
        commonConfig.chainId = chainId;
        return commonConfig;
    }

    public SystemProperties systemProperties() {
        return SystemProperties.getSpringDefault();
    }

    public Repository defaultRepository() {
        return new RepositoryRoot(this.stateSource(), null);
    }

    public Repository repository(byte[] stateRoot) {
        return new RepositoryRoot(this.stateSource(), stateRoot);
    }

    public Source<byte[], byte[]> trieNodeSource() {
        if (this.trieNodeSource == null) {
            DbSource<byte[]> db = this.blockchainDB();
            PrefixLookupSource<byte[]> src = new PrefixLookupSource<byte[]>(db, 16);
            this.trieNodeSource = new XorDataSource<byte[]>(src, HashUtil.sha3("state".getBytes()));
        }
        return this.trieNodeSource;
    }

    public StateSource stateSource() {
        if (this.stateSource == null) {
            StateSource stateSource = new StateSource(this.blockchainSource("state"), this.systemProperties().databasePruneDepth() >= 0);
            this.dbFlushManager().addCache(stateSource.getWriteCache());
            this.stateSource = stateSource;
        }
        return this.stateSource;
    }

    public Source<byte[], byte[]> cachedDbSource(String name) {
        AsyncWriteCache<byte[], byte[]> writeCache = new AsyncWriteCache<byte[], byte[]>(this.blockchainSource(name)){

            @Override
            protected WriteCache<byte[], byte[]> createCache(Source<byte[], byte[]> source) {
                WriteCache.BytesKey<byte[]> ret = new WriteCache.BytesKey<byte[]>(source, WriteCache.CacheType.SIMPLE);
                ret.withSizeEstimators(MemSizeEstimator.ByteArrayEstimator, MemSizeEstimator.ByteArrayEstimator);
                ret.setFlushSource(true);
                return ret;
            }
        }.withName(name);
        this.dbFlushManager().addCache(writeCache);
        return writeCache;
    }

    public Source<byte[], byte[]> blockchainSource(String name) {
        return new XorDataSource<byte[]>(this.blockchainDbCache(), HashUtil.sha3(name.getBytes()));
    }

    public AbstractCachedSource<byte[], byte[]> blockchainDbCache() {
        if (this.blockchainDbCache == null) {
            WriteCache.BytesKey ret = new WriteCache.BytesKey(new BatchSourceWriter(this.blockchainDB()), WriteCache.CacheType.SIMPLE);
            ret.setFlushSource(true);
            this.blockchainDbCache = ret;
        }
        return this.blockchainDbCache;
    }

    public DbSource<byte[]> keyValueDataSource(String name) {
        return this.keyValueDataSource(name, DbSettings.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbSource<byte[]> keyValueDataSource(String name, DbSettings settings) {
        String dataSource = this.systemProperties().getKeyValueDataSource();
        try {
            DbSource<byte[]> dbSource = "inmem".equals(dataSource) ? new HashMapDB() : this.rocksDbDataSource();
            dbSource.setName(name);
            dbSource.init(settings);
            this.dbSources.add(dbSource);
            DbSource<byte[]> dbSource2 = dbSource;
            return dbSource2;
        }
        finally {
            logger.debug(dataSource + " key-value entity source created: " + name);
        }
    }

    protected RocksDbDataSource rocksDbDataSource() {
        return new RocksDbDataSource(this.chainId);
    }

    private void resetDataSource(Source source) {
        if (!(source instanceof DbSource)) {
            throw new Error("Cannot cleanup non-db Source");
        }
        ((DbSource)source).reset();
    }

    public DbSource<byte[]> headerSource() {
        if (this.headerSource == null) {
            this.headerSource = this.keyValueDataSource("headers");
        }
        return this.headerSource;
    }

    public HeaderStore headerStore() {
        if (this.headerStore == null) {
            DbSource<byte[]> dataSource = this.headerSource();
            WriteCache.BytesKey cache = new WriteCache.BytesKey(new BatchSourceWriter(dataSource), WriteCache.CacheType.SIMPLE);
            cache.setFlushSource(true);
            this.dbFlushManager().addCache(cache);
            HeaderStore headerStore = new HeaderStore();
            XorDataSource<byte[]> headers = new XorDataSource<byte[]>(cache, HashUtil.sha3("header".getBytes()));
            XorDataSource<byte[]> index = new XorDataSource<byte[]>(cache, HashUtil.sha3("index".getBytes()));
            headerStore.init(index, headers);
            this.headerStore = headerStore;
        }
        return this.headerStore;
    }

    public DbSource<byte[]> blockchainDB() {
        if (this.blockchainDB == null) {
            DbSettings settings = DbSettings.newInstance().withMaxOpenFiles(this.systemProperties().getConfig().getInt("database.maxOpenFiles")).withMaxThreads(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
            this.blockchainDB = this.keyValueDataSource("blockchain", settings);
        }
        return this.blockchainDB;
    }

    public DbFlushManager dbFlushManager() {
        if (this.dbFlushManager == null) {
            this.dbFlushManager = new DbFlushManager(this.systemProperties(), this.dbSources, this.blockchainDbCache());
        }
        return this.dbFlushManager;
    }
}

