/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.ArrayList;
import java.util.List;
import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.HashedKeySource;
import org.ethereum.datasource.Serializer;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.SourceCodec;
import org.ethereum.datasource.inmem.HashMapDB;
import org.ethereum.util.RLP;
import org.ethereum.util.RLPElement;
import org.ethereum.util.RLPList;

public class JournalSource<V>
extends AbstractChainedSource<byte[], V, byte[], V>
implements HashedKeySource<byte[], V> {
    private Update currentUpdate = new Update();
    Source<byte[], Update> journal = new HashMapDB<Update>();

    public JournalSource(Source<byte[], V> src) {
        super(src);
    }

    public void setJournalStore(Source<byte[], byte[]> journalSource) {
        this.journal = new SourceCodec.BytesKey<Update, byte[]>(journalSource, new Serializer<Update, byte[]>(){

            @Override
            public byte[] serialize(Update object) {
                return object.serialize();
            }

            @Override
            public Update deserialize(byte[] stream) {
                return stream == null ? null : new Update(stream);
            }
        });
    }

    @Override
    public synchronized void put(byte[] key, V val) {
        if (val == null) {
            this.delete(key);
            return;
        }
        this.getSource().put(key, val);
        this.currentUpdate.insertedKeys.add(key);
    }

    @Override
    public synchronized void delete(byte[] key) {
        this.currentUpdate.deletedKeys.add(key);
    }

    @Override
    public synchronized V get(byte[] key) {
        return (V)this.getSource().get(key);
    }

    public synchronized Update commitUpdates(byte[] updateHash) {
        this.currentUpdate.updateHash = updateHash;
        this.journal.put(updateHash, this.currentUpdate);
        Update committed = this.currentUpdate;
        this.currentUpdate = new Update();
        return committed;
    }

    public Source<byte[], Update> getJournal() {
        return this.journal;
    }

    @Override
    public synchronized boolean flushImpl() {
        this.journal.flush();
        return false;
    }

    public static class Update {
        byte[] updateHash;
        List<byte[]> insertedKeys = new ArrayList<byte[]>();
        List<byte[]> deletedKeys = new ArrayList<byte[]>();

        public Update() {
        }

        public Update(byte[] bytes) {
            this.parse(bytes);
        }

        public byte[] serialize() {
            byte[][] insertedBytes = new byte[this.insertedKeys.size()][];
            for (int i = 0; i < insertedBytes.length; ++i) {
                insertedBytes[i] = RLP.encodeElement(this.insertedKeys.get(i));
            }
            byte[][] deletedBytes = new byte[this.deletedKeys.size()][];
            for (int i = 0; i < deletedBytes.length; ++i) {
                deletedBytes[i] = RLP.encodeElement(this.deletedKeys.get(i));
            }
            return RLP.encodeList(RLP.encodeElement(this.updateHash), RLP.encodeList(insertedBytes), RLP.encodeList(deletedBytes));
        }

        private void parse(byte[] encoded) {
            RLPList l = (RLPList)RLP.decode2(encoded).get(0);
            this.updateHash = ((RLPElement)l.get(0)).getRLPData();
            for (RLPElement aRInserted : (RLPList)l.get(1)) {
                this.insertedKeys.add(aRInserted.getRLPData());
            }
            for (RLPElement aRDeleted : (RLPList)l.get(2)) {
                this.deletedKeys.add(aRDeleted.getRLPData());
            }
        }

        public List<byte[]> getInsertedKeys() {
            return this.insertedKeys;
        }

        public List<byte[]> getDeletedKeys() {
            return this.deletedKeys;
        }
    }
}

