/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.CachedSource;
import org.ethereum.datasource.Source;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.util.ByteArrayMap;

public class ReadCache<Key, Value>
extends AbstractCachedSource<Key, Value> {
    private final Value NULL = new Object();
    private Map<Key, Value> cache;
    private boolean byteKeyMap;
    private boolean checked = false;

    public ReadCache(Source<Key, Value> src) {
        super(src);
        this.withCache(new HashMap());
    }

    public ReadCache<Key, Value> withCache(Map<Key, Value> cache) {
        this.byteKeyMap = cache instanceof ByteArrayMap;
        this.cache = Collections.synchronizedMap(cache);
        return this;
    }

    public ReadCache<Key, Value> withMaxCapacity(int maxCapacity) {
        return this.withCache((Map<Key, Value>)new LRUMap<Key, Value>(maxCapacity){

            protected boolean removeLRU(AbstractLinkedMap.LinkEntry<Key, Value> entry) {
                ReadCache.this.cacheRemoved(entry.getKey(), entry.getValue());
                return super.removeLRU(entry);
            }
        });
    }

    private void checkByteArrKey(Key key) {
        if (this.checked) {
            return;
        }
        if (key instanceof byte[] && !this.byteKeyMap) {
            throw new RuntimeException("Wrong map/set for byte[] key");
        }
        this.checked = true;
    }

    @Override
    public void put(Key key, Value val) {
        this.checkByteArrKey(key);
        if (val == null) {
            this.delete(key);
        } else {
            this.cache.put(key, val);
            this.cacheAdded(key, val);
            this.getSource().put(key, val);
        }
    }

    @Override
    public Value get(Key key) {
        this.checkByteArrKey(key);
        Object ret = this.cache.get(key);
        if (ret == this.NULL) {
            return null;
        }
        if (ret == null) {
            ret = this.getSource().get(key);
            this.cache.put(key, ret == null ? this.NULL : ret);
            this.cacheAdded(key, ret);
        }
        return ret;
    }

    @Override
    public void delete(Key key) {
        this.checkByteArrKey(key);
        Value value = this.cache.remove(key);
        this.cacheRemoved(key, value);
        this.getSource().delete(key);
    }

    @Override
    protected boolean flushImpl() {
        return false;
    }

    @Override
    public synchronized Collection<Key> getModified() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasModified() {
        return false;
    }

    @Override
    public synchronized AbstractCachedSource.Entry<Value> getCached(Key key) {
        Value value = this.cache.get(key);
        return value == null ? null : new AbstractCachedSource.SimpleEntry<Object>((value == this.NULL ? null : (Object)value));
    }

    public static class BytesKey<V>
    extends ReadCache<byte[], V>
    implements CachedSource.BytesKey<V> {
        public BytesKey(Source<byte[], V> src) {
            super(src);
            this.withCache(new ByteArrayMap());
        }

        public BytesKey<V> withMaxCapacity(int maxCapacity) {
            this.withCache(new ByteArrayMap(new LRUMap<ByteArrayWrapper, V>(maxCapacity){

                protected boolean removeLRU(AbstractLinkedMap.LinkEntry<ByteArrayWrapper, V> entry) {
                    this.cacheRemoved(((ByteArrayWrapper)entry.getKey()).getData(), entry.getValue());
                    return super.removeLRU(entry);
                }
            }));
            return this;
        }
    }
}

