/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource.inmem;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ethereum.datasource.DbSettings;
import org.ethereum.datasource.DbSource;
import org.ethereum.util.ALock;
import org.ethereum.util.ByteArrayMap;
import org.ethereum.util.FastByteComparisons;

public class HashMapDB<V>
implements DbSource<V> {
    protected final Map<byte[], V> storage;
    protected ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected ALock readLock = new ALock(this.rwLock.readLock());
    protected ALock writeLock = new ALock(this.rwLock.writeLock());

    public HashMapDB() {
        this(new ByteArrayMap());
    }

    public HashMapDB(ByteArrayMap<V> storage) {
        this.storage = storage;
    }

    @Override
    public void put(byte[] key, V val) {
        if (val == null) {
            this.delete(key);
        } else {
            try (ALock l = this.writeLock.lock();){
                this.storage.put(key, val);
            }
        }
    }

    @Override
    public V get(byte[] key) {
        try (ALock l = this.readLock.lock();){
            V v = this.storage.get(key);
            return v;
        }
    }

    @Override
    public void delete(byte[] key) {
        try (ALock l = this.writeLock.lock();){
            this.storage.remove(key);
        }
    }

    @Override
    public boolean flush() {
        return true;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return "in-memory";
    }

    @Override
    public void init() {
    }

    @Override
    public void init(DbSettings settings) {
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Set<byte[]> keys() {
        try (ALock l = this.readLock.lock();){
            Set<byte[]> set = this.getStorage().keySet();
            return set;
        }
    }

    @Override
    public void reset() {
        try (ALock l = this.writeLock.lock();){
            this.storage.clear();
        }
    }

    @Override
    public V prefixLookup(byte[] key, int prefixBytes) {
        try (ALock l = this.readLock.lock();){
            for (Map.Entry<byte[], V> e : this.storage.entrySet()) {
                if (FastByteComparisons.compareTo(key, 0, prefixBytes, e.getKey(), 0, prefixBytes) != 0) continue;
                V v = e.getValue();
                return v;
            }
            Iterator<Map.Entry<byte[], V>> iterator = null;
            return (V)iterator;
        }
    }

    @Override
    public void updateBatch(Map<byte[], V> rows) {
        try (ALock l = this.writeLock.lock();){
            for (Map.Entry<byte[], V> entry : rows.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<byte[], V> getStorage() {
        return this.storage;
    }
}

