/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import org.ethereum.core.BlockHeader;
import org.ethereum.datasource.DataSourceArray;
import org.ethereum.datasource.ObjectDataSource;
import org.ethereum.datasource.Serializers;
import org.ethereum.datasource.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderStore {
    private static final Logger logger = LoggerFactory.getLogger((String)"general");
    Source<byte[], byte[]> indexDS;
    DataSourceArray<byte[]> index;
    Source<byte[], byte[]> headersDS;
    ObjectDataSource<BlockHeader> headers;

    public void init(Source<byte[], byte[]> index, Source<byte[], byte[]> headers) {
        this.indexDS = index;
        this.index = new DataSourceArray<byte[]>(new ObjectDataSource<byte[]>(index, Serializers.AsIsSerializer, 2048));
        this.headersDS = headers;
        this.headers = new ObjectDataSource<BlockHeader>(headers, Serializers.BlockHeaderSerializer, 512);
    }

    public synchronized BlockHeader getBestHeader() {
        long maxNumber = this.getMaxNumber();
        if (maxNumber < 0L) {
            return null;
        }
        return this.getHeaderByNumber(maxNumber);
    }

    public synchronized void flush() {
        this.headers.flush();
        this.index.flush();
        this.headersDS.flush();
        this.indexDS.flush();
    }

    public synchronized void saveHeader(BlockHeader header) {
        this.index.set((int)header.getNumber(), header.getHash());
        this.headers.put(header.getHash(), header);
    }

    public synchronized BlockHeader getHeaderByNumber(long number) {
        if (number < 0L || number >= (long)this.index.size()) {
            return null;
        }
        byte[] hash = this.index.get((int)number);
        if (hash == null) {
            return null;
        }
        return (BlockHeader)this.headers.get(hash);
    }

    public synchronized int size() {
        return this.index.size();
    }

    public synchronized BlockHeader getHeaderByHash(byte[] hash) {
        return (BlockHeader)this.headers.get(hash);
    }

    public synchronized long getMaxNumber() {
        if (this.index.size() > 0) {
            return (long)this.index.size() - 1L;
        }
        return -1L;
    }
}

