/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db.prune;

import java.util.Arrays;
import org.ethereum.core.Block;
import org.ethereum.util.FastByteComparisons;

class ChainItem {
    long number;
    byte[] hash;
    byte[] parentHash;

    ChainItem(Block block) {
        this.number = block.getNumber();
        this.hash = block.getHash();
        this.parentHash = block.getParentHash();
    }

    ChainItem(long number, byte[] hash, byte[] parentHash) {
        this.number = number;
        this.hash = hash;
        this.parentHash = parentHash;
    }

    boolean isParentOf(ChainItem that) {
        return FastByteComparisons.equal(this.hash, that.parentHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainItem that = (ChainItem)o;
        return FastByteComparisons.equal(this.hash, that.hash);
    }

    public int hashCode() {
        return this.hash != null ? Arrays.hashCode(this.hash) : 0;
    }

    public String toString() {
        return String.valueOf(this.number);
    }
}

