/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db.prune;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ethereum.core.Block;
import org.ethereum.db.prune.Chain;
import org.ethereum.db.prune.ChainItem;

public class Segment {
    List<Chain> forks = new ArrayList<Chain>();
    Chain main = Chain.NULL;
    ChainItem root;

    public Segment(Block root) {
        this.root = new ChainItem(root);
    }

    public Segment(long number, byte[] hash, byte[] parentHash) {
        this.root = new ChainItem(number, hash, parentHash);
    }

    public boolean isComplete() {
        if (this.main == Chain.NULL) {
            return false;
        }
        for (Chain fork : this.forks) {
            if (this.main.isHigher(fork)) continue;
            return false;
        }
        return true;
    }

    public long getRootNumber() {
        return this.root.number;
    }

    public long getMaxNumber() {
        return this.main.topNumber();
    }

    public Tracker startTracking() {
        return new Tracker(this);
    }

    public int size() {
        return this.main.items.size();
    }

    private void branch(ChainItem item) {
        this.forks.add(new Chain(item));
    }

    private void connectMain(ChainItem item) {
        if (this.main == Chain.NULL) {
            if (this.root.isParentOf(item)) {
                this.main = new Chain(item);
            }
        } else {
            this.main.connect(item);
        }
    }

    private void connectFork(ChainItem item) {
        for (Chain fork : this.forks) {
            if (!fork.contains(item)) continue;
            return;
        }
        if (this.root.isParentOf(item)) {
            this.branch(item);
        } else {
            for (ChainItem mainItem : this.main.items) {
                if (!mainItem.isParentOf(item)) continue;
                this.branch(item);
            }
            for (Chain fork : this.forks) {
                if (!fork.connect(item)) continue;
                return;
            }
            ArrayList<Chain> branchedForks = new ArrayList<Chain>();
            for (Chain fork : this.forks) {
                for (ChainItem forkItem : fork.items) {
                    if (!forkItem.isParentOf(item)) continue;
                    branchedForks.add(new Chain(item));
                }
            }
            this.forks.addAll(branchedForks);
        }
    }

    public String toString() {
        return "" + this.main;
    }

    public static final class Tracker {
        Segment segment;
        List<ChainItem> main = new ArrayList<ChainItem>();
        List<ChainItem> items = new ArrayList<ChainItem>();

        Tracker(Segment segment) {
            this.segment = segment;
        }

        public void addMain(Block block) {
            this.main.add(new ChainItem(block));
        }

        public void addAll(List<Block> blocks) {
            this.items.addAll(blocks.stream().map(ChainItem::new).collect(Collectors.toList()));
        }

        public Tracker addMain(long number, byte[] hash, byte[] parentHash) {
            this.main.add(new ChainItem(number, hash, parentHash));
            return this;
        }

        public Tracker addItem(long number, byte[] hash, byte[] parentHash) {
            this.items.add(new ChainItem(number, hash, parentHash));
            return this;
        }

        public void commit() {
            this.items.removeAll(this.main);
            this.main.sort((i1, i2) -> Long.compare(i1.number, i2.number));
            this.items.sort((i1, i2) -> Long.compare(i1.number, i2.number));
            this.main.forEach(x$0 -> this.segment.connectMain((ChainItem)x$0));
            this.items.forEach(x$0 -> this.segment.connectFork((ChainItem)x$0));
        }
    }
}

