/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static List<String> recursiveList(String path) throws IOException {
        final ArrayList<String> files = new ArrayList<String>();
        Files.walkFileTree(Paths.get(path, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    public static boolean recursiveDelete(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory() && file.list().length > 0) {
                for (String s : file.list()) {
                    FileUtil.recursiveDelete(fileName + System.getProperty("file.separator") + s);
                }
            }
            file.setWritable(true);
            boolean result = file.delete();
            return result;
        }
        return false;
    }
}

