/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.parse;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class MapUtils {
    public static <T> Map<String, Object> beanToLinkedMap(T bean) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            Object[] keys = beanMap.keySet().toArray();
            Arrays.sort(keys);
            for (Object key : keys) {
                map.put("" + key, beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put("" + key, beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (objList != null && objList.size() > 0) {
            Map<String, Object> map = null;
            T bean = null;
            int size = objList.size();
            for (int i = 0; i < size; ++i) {
                bean = objList.get(i);
                map = MapUtils.beanToMap(bean);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps, Class<T> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (maps != null && maps.size() > 0) {
            Map<String, Object> map = null;
            Object bean = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                bean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                MapUtils.mapToBean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }
}

