/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.channel;

import io.netty.channel.socket.SocketChannel;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.RequestOnly;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.channel.EventListener;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.core.thread.commom.NulsThreadFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;

public class ConnectData {
    private final SocketChannel channel;
    private boolean connected = true;
    private long requestOnlyQueueMemSize = 0L;
    private final LinkedBlockingQueue<Response> responseAutoQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<RequestOnly> requestOnlyQueue = new LinkedBlockingQueue(100000);
    private final List<String> timeOutMessageList = new ArrayList<String>();
    private final Map<Message, Long> cmdInvokeTime = new ConcurrentHashMap<Message, Long>();
    private final LinkedBlockingQueue<Object[]> requestPeriodLoopQueue = new LinkedBlockingQueue();
    private final List<Message> requestEventCountLoopList = new CopyOnWriteArrayList<Message>();
    private final LinkedBlockingQueue<Response> requestEventResponseQueue = new LinkedBlockingQueue();
    private final Map<String, Message> idToPeriodMessageMap = new ConcurrentHashMap<String, Message>();
    private final Map<String, Message> idToEventMessageMap = new ConcurrentHashMap<String, Message>();
    private final Map<String, Integer> subscribeInitCount = new ConcurrentHashMap<String, Integer>();
    private final List<EventListener> closeEventListenerList = new ArrayList<EventListener>();
    private final ExecutorService threadPool = ThreadUtils.createThreadPool((int)6, (int)100, (NulsThreadFactory)new NulsThreadFactory("ServerProcessor"));

    private boolean periodMessageIsExist(String messageId) {
        return this.idToPeriodMessageMap.containsKey(messageId);
    }

    private boolean eventMessageIsExist(String messageId) {
        return this.idToEventMessageMap.containsKey(messageId);
    }

    public void subscribeByEvent(Message message, Request request) {
        ConnectManager.subscribeByEvent(this, message, request);
        this.idToEventMessageMap.put(message.getMessageID(), message);
        this.addSubscribeInitCount(message);
        this.requestEventCountLoopList.add(message);
    }

    public void unsubscribe(String messageId) {
        if (this.periodMessageIsExist(messageId)) {
            Message message = this.idToPeriodMessageMap.remove(messageId);
            this.cmdInvokeTime.remove(message);
            this.requestPeriodLoopQueue.remove(message);
        } else if (this.eventMessageIsExist(messageId)) {
            Message message = this.idToEventMessageMap.remove(messageId);
            this.requestEventCountLoopList.remove(message);
            this.removeSubscribeInitCount(message);
            ConnectManager.unsubscribeByEvent(message);
        }
    }

    public void addSubscribeInitCount(Message message) {
        Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
        Iterator<String> iterator = request.getRequestMethods().keySet().iterator();
        while (iterator.hasNext()) {
            String method;
            String cmd = method = iterator.next();
            String key = ConnectManager.getSubscribeKey(message.getMessageID(), cmd);
            if (this.subscribeInitCount.containsKey(key)) continue;
            this.subscribeInitCount.put(key, ConnectManager.getCmdChangeCount(cmd));
        }
    }

    public void removeSubscribeInitCount(Message message) {
        Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
        Iterator<String> iterator = request.getRequestMethods().keySet().iterator();
        while (iterator.hasNext()) {
            String method;
            String cmd = method = iterator.next();
            String key = ConnectManager.getSubscribeKey(message.getMessageID(), cmd);
            if (!this.subscribeInitCount.containsKey(key)) continue;
            this.subscribeInitCount.remove(key);
        }
    }

    public ConnectData(SocketChannel channel) {
        this.channel = channel;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
        if (!connected) {
            this.requestEventResponseQueue.clear();
            this.requestEventResponseQueue.offer(new Response());
            this.responseAutoQueue.clear();
            this.responseAutoQueue.offer(new Response());
            this.requestPeriodLoopQueue.clear();
            this.emitCloseEvent();
        }
    }

    public Map<Message, Long> getCmdInvokeTime() {
        return this.cmdInvokeTime;
    }

    public LinkedBlockingQueue<Object[]> getRequestPeriodLoopQueue() {
        return this.requestPeriodLoopQueue;
    }

    public List<Message> getRequestEventCountLoopList() {
        return this.requestEventCountLoopList;
    }

    public LinkedBlockingQueue<Response> getRequestEventResponseQueue() {
        return this.requestEventResponseQueue;
    }

    public Map<String, Message> getIdToPeriodMessageMap() {
        return this.idToPeriodMessageMap;
    }

    public Map<String, Message> getIdToEventMessageMap() {
        return this.idToEventMessageMap;
    }

    public Map<String, Integer> getSubscribeInitCount() {
        return this.subscribeInitCount;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public LinkedBlockingQueue<Response> getResponseAutoQueue() {
        return this.responseAutoQueue;
    }

    public List<String> getTimeOutMessageList() {
        return this.timeOutMessageList;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public LinkedBlockingQueue<RequestOnly> getRequestOnlyQueue() {
        return this.requestOnlyQueue;
    }

    public long getRequestOnlyQueueMemSize() {
        return this.requestOnlyQueueMemSize;
    }

    public void setRequestOnlyQueueMemSize(long requestOnlyQueueMemSize) {
        this.requestOnlyQueueMemSize = requestOnlyQueueMemSize;
    }

    public boolean requestOnlyQueueReachLimit() {
        return 0x8000000L <= this.requestOnlyQueueMemSize;
    }

    public void addRequestOnlyQueueMemSize(long requestOnlyMemSize) {
        this.requestOnlyQueueMemSize += requestOnlyMemSize;
    }

    public void subRequestOnlyQueueMemSize(long requestOnlyMemSize) {
        this.requestOnlyQueueMemSize -= requestOnlyMemSize;
    }

    public void addCloseEvent(EventListener eventListener) {
        this.closeEventListenerList.add(eventListener);
    }

    public void emitCloseEvent() {
        this.closeEventListenerList.forEach(f -> f.apply());
    }
}

