/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.CreateAccountReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;

@Component
public class CreateProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "create";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t[number] The count of accounts you want to create, - default 1").newLine("\t[password] setting account password");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "create [number] [password] --create account, [number] the number of accounts you want to create, - default 1. [password] setting account password";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 0, 1, 2);
        if (args.length == 1) {
            return true;
        }
        this.checkArgs(StringUtils.isNumeric((String)args[1]), "must enter a number");
        this.checkArgs(Integer.parseInt(args[1]) > 0, "must be greater than zero");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String password = null;
        if (args.length == 3) {
            password = args[2];
        } else {
            password = this.getPwd("Please enter the new password(8-20 characters, the combination of letters and numbers).\nEnter your new password:");
            if (StringUtils.isNotBlank((String)password) && !CommandHelper.confirmPwd(password)) {
                return CommandResult.getFailed("Password confirmation doesn't match the password.Operation abort.");
            }
        }
        int count = 1;
        if (args.length == 2) {
            count = Integer.parseInt(args[1]);
        }
        if (!(result = this.accountService.createAccount(new CreateAccountReq(count, password))).isSuccess()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }
}

