/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.ImportAccountByKeyStoreReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import java.io.File;

@Component
public class ImportByKeyStoreProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "importkeystore";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<path> The path to the AccountKeystore file ");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "importkeystore <path> -- import accounts according to AccountKeystore files";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkArgs(new File(args[1]).exists(), "keystore file not exists");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String keystore;
        String path = args[1];
        String password = CommandHelper.getPwdOptional();
        ImportAccountByKeyStoreReq req = new ImportAccountByKeyStoreReq(password, HexUtil.encode((byte[])(keystore = this.accountService.getAccountKeystoreDto(path)).getBytes()), true);
        Result result = this.accountService.importAccountByKeyStore(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

