/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.ImportAccountByPrivateKeyReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;

@Component
public class ImportByPrivateKeyProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "import";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<privatekey> private key - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "import <privatekey> --import the account according to the private key, if the account exists, it will not be executed ";
    }

    @Override
    public boolean argsValidate(String[] args) {
        int length = args.length;
        if (length < 2) {
            return false;
        }
        return CommandHelper.checkArgsIsNull(args);
    }

    @Override
    public CommandResult execute(String[] args) {
        String password;
        String prikey = args[1];
        if (args.length > 2) {
            password = args[2];
        } else {
            password = CommandHelper.getPwdOptional();
            if (StringUtils.isNotBlank((String)password) && !CommandHelper.confirmPwd(password)) {
                return CommandResult.getFailed("Password confirmation doesn't match the password.Operation abort.");
            }
        }
        ImportAccountByPrivateKeyReq req = new ImportAccountByPrivateKeyReq(password, prikey, true);
        Result result = this.accountService.importAccountByPrivateKey(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

